/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.VectorMath;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Vectors - Rotate around XYZ")
@Description(value={"Rotates a vector around x, y, or z axis by some degrees"})
@Examples(value={"rotate {_v} around x-axis by 90", "rotate {_v} around y-axis by 90", "rotate {_v} around z-axis by 90"})
@Since(value="2.2-dev28")
public class EffVectorRotateXYZ
extends Effect {
    private static final Character[] axes;
    private Expression<Vector> vectors;
    private Expression<Number> number;
    private int mark;

    static {
        Skript.registerEffect(EffVectorRotateXYZ.class, "rotate %vectors% around (1\u00a6x|2\u00a6y|3\u00a6z)(-| )axis by %number% [degrees]");
        axes = new Character[]{Character.valueOf('x'), Character.valueOf('y'), Character.valueOf('z')};
    }

    @Override
    public String toString(@Nullable Event event, boolean b) {
        return "rotate " + this.vectors.toString() + " around " + axes[this.mark] + "-axis";
    }

    @Override
    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.vectors = expressions[0];
        this.number = expressions[1];
        this.mark = parseResult.mark;
        return true;
    }

    @Override
    protected void execute(Event event) {
        Number n = this.number.getSingle(event);
        if (n == null) {
            return;
        }
        switch (this.mark) {
            case 1: {
                Vector[] vectorArray = this.vectors.getAll(event);
                int n2 = vectorArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    Vector v = vectorArray[n3];
                    VectorMath.rotX(v, n.doubleValue());
                    ++n3;
                }
                break;
            }
            case 2: {
                Vector[] vectorArray = this.vectors.getAll(event);
                int n4 = vectorArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    Vector v = vectorArray[n5];
                    VectorMath.rotY(v, n.doubleValue());
                    ++n5;
                }
                break;
            }
            case 3: {
                Vector[] vectorArray = this.vectors.getAll(event);
                int n6 = vectorArray.length;
                int n7 = 0;
                while (n7 < n6) {
                    Vector v = vectorArray[n7];
                    VectorMath.rotZ(v, n.doubleValue());
                    ++n7;
                }
                break;
            }
        }
    }
}

