/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.classes.data;

import ch.njol.skript.SkriptConfig;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.NumberArithmetic;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.skript.localization.Message;
import ch.njol.skript.localization.RegexMessage;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Utils;
import ch.njol.util.StringUtils;
import ch.njol.yggdrasil.Fields;
import java.io.StreamCorruptedException;
import org.eclipse.jdt.annotation.Nullable;

public class JavaClasses {
    public static final int VARIABLENAME_NUMBERACCURACY = 8;

    static {
        Classes.registerClass(new ClassInfo<Object>(Object.class, "object").user("objects?").name("Object").description("The supertype of all types, meaning that if %object% is used in e.g. a condition it will accept all kinds of expressions.").usage("").examples("").since("1.0"));
        Classes.registerClass(new ClassInfo<Number>(Number.class, "number").user("num(ber)?s?").name("Number").description("A number, e.g. 2.5, 3, or -9812454.", "Please note that many expressions only need integers, i.e. will discard any frational parts of any numbers without producing an error.").usage("[-]###[.###]</code> (any amount of digits; very large numbers will be truncated though)").examples("set the player's health to 5.5", "set {_temp} to 2*{_temp} - 2.5").since("1.0").defaultExpression(new SimpleLiteral<Integer>(1, true)).parser((Parser<Integer>)new Parser<Number>(){

            @Override
            @Nullable
            public Number parse(String s, ParseContext context) {
                try {
                    return Long.valueOf(s);
                }
                catch (NumberFormatException numberFormatException) {
                    Double d;
                    block5: {
                        try {
                            d = s.endsWith("%") ? Double.parseDouble(s.substring(0, s.length() - 1)) / 100.0 : Double.parseDouble(s);
                            if (!d.isNaN() && !d.isInfinite()) break block5;
                            return null;
                        }
                        catch (NumberFormatException e) {
                            return null;
                        }
                    }
                    return d;
                }
            }

            @Override
            public String toString(Number n, int flags) {
                return StringUtils.toString(n.doubleValue(), SkriptConfig.numberAccuracy.value());
            }

            @Override
            public String toVariableNameString(Number n) {
                return StringUtils.toString(n.doubleValue(), 8);
            }

            @Override
            public String getVariableNamePattern() {
                return "-?\\d+(\\.\\d+)?";
            }
        }).serializer((Serializer<Integer>)new Serializer<Number>(){

            @Override
            public Fields serialize(Number n) {
                throw new IllegalStateException();
            }

            @Override
            public boolean canBeInstantiated() {
                return true;
            }

            @Override
            public void deserialize(Number o, Fields f) throws StreamCorruptedException {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }

            @Override
            @Nullable
            public Number deserialize(String s) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        return Double.valueOf(s);
                    }
                    catch (NumberFormatException e) {
                        return null;
                    }
                }
            }

            @Override
            public boolean mustSyncDeserialization() {
                return false;
            }
        }).math(Number.class, new NumberArithmetic()));
        Classes.registerClass(new ClassInfo<Long>(Long.class, "long").user("int(eger)?s?").name(ClassInfo.NO_DOC).before("integer", "short", "byte").defaultExpression(new SimpleLiteral<Long>(1L, true)).parser(new Parser<Long>(){

            @Override
            @Nullable
            public Long parse(String s, ParseContext context) {
                try {
                    return Long.valueOf(s);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }

            @Override
            public String toString(Long l, int flags) {
                return "" + l;
            }

            @Override
            public String toVariableNameString(Long l) {
                return "" + l;
            }

            @Override
            public String getVariableNamePattern() {
                return "-?\\d+";
            }
        }).serializer(new Serializer<Long>(){

            @Override
            public Fields serialize(Long n) {
                throw new IllegalStateException();
            }

            @Override
            public boolean canBeInstantiated() {
                return true;
            }

            @Override
            public void deserialize(Long o, Fields f) throws StreamCorruptedException {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }

            @Override
            @Nullable
            public Long deserialize(String s) {
                try {
                    return Long.parseLong(s);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }

            @Override
            public boolean mustSyncDeserialization() {
                return false;
            }
        }).math(Number.class, new NumberArithmetic()));
        Classes.registerClass(new ClassInfo<Integer>(Integer.class, "integer").name(ClassInfo.NO_DOC).defaultExpression(new SimpleLiteral<Integer>(1, true)).parser(new Parser<Integer>(){

            @Override
            @Nullable
            public Integer parse(String s, ParseContext context) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }

            @Override
            public String toString(Integer i, int flags) {
                return "" + i;
            }

            @Override
            public String toVariableNameString(Integer i) {
                return "" + i;
            }

            @Override
            public String getVariableNamePattern() {
                return "-?\\d+";
            }
        }).serializer(new Serializer<Integer>(){

            @Override
            public Fields serialize(Integer n) {
                throw new IllegalStateException();
            }

            @Override
            public boolean canBeInstantiated() {
                return true;
            }

            @Override
            public void deserialize(Integer o, Fields f) throws StreamCorruptedException {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }

            @Override
            @Nullable
            public Integer deserialize(String s) {
                try {
                    return Integer.parseInt(s);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }

            @Override
            public boolean mustSyncDeserialization() {
                return false;
            }
        }).math(Number.class, new NumberArithmetic()));
        Classes.registerClass(new ClassInfo<Double>(Double.class, "double").name(ClassInfo.NO_DOC).defaultExpression(new SimpleLiteral<Double>(1.0, true)).after("long").before("float", "integer", "short", "byte").parser(new Parser<Double>(){

            @Override
            @Nullable
            public Double parse(String s, ParseContext context) {
                Double d;
                block3: {
                    try {
                        d = s.endsWith("%") ? Double.parseDouble(s.substring(0, s.length() - 1)) / 100.0 : Double.parseDouble(s);
                        if (!d.isNaN() && !d.isInfinite()) break block3;
                        return null;
                    }
                    catch (NumberFormatException e) {
                        return null;
                    }
                }
                return d;
            }

            @Override
            public String toString(Double d, int flags) {
                return StringUtils.toString(d, SkriptConfig.numberAccuracy.value());
            }

            @Override
            public String toVariableNameString(Double d) {
                return StringUtils.toString(d, 8);
            }

            @Override
            public String getVariableNamePattern() {
                return "-?\\d+(\\.\\d+)?";
            }
        }).serializer(new Serializer<Double>(){

            @Override
            public Fields serialize(Double n) {
                throw new IllegalStateException();
            }

            @Override
            public boolean canBeInstantiated() {
                return true;
            }

            @Override
            public void deserialize(Double o, Fields f) throws StreamCorruptedException {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }

            @Override
            @Nullable
            public Double deserialize(String s) {
                try {
                    return Double.parseDouble(s);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }

            @Override
            public boolean mustSyncDeserialization() {
                return false;
            }
        }).math(Number.class, new NumberArithmetic()));
        Classes.registerClass(new ClassInfo<Float>(Float.class, "float").name(ClassInfo.NO_DOC).defaultExpression(new SimpleLiteral<Float>(Float.valueOf(1.0f), true)).parser(new Parser<Float>(){

            @Override
            @Nullable
            public Float parse(String s, ParseContext context) {
                Float f;
                block3: {
                    try {
                        f = Float.valueOf(s.endsWith("%") ? Float.parseFloat(s.substring(0, s.length() - 1)) / 100.0f : Float.parseFloat(s));
                        if (!f.isNaN() && !f.isInfinite()) break block3;
                        return null;
                    }
                    catch (NumberFormatException e) {
                        return null;
                    }
                }
                return f;
            }

            @Override
            public String toString(Float f, int flags) {
                return StringUtils.toString(f.floatValue(), SkriptConfig.numberAccuracy.value());
            }

            @Override
            public String toVariableNameString(Float f) {
                return StringUtils.toString(f.doubleValue(), 8);
            }

            @Override
            public String getVariableNamePattern() {
                return "-?\\d+(\\.\\d+)?";
            }
        }).serializer(new Serializer<Float>(){

            @Override
            public Fields serialize(Float n) {
                throw new IllegalStateException();
            }

            @Override
            public boolean canBeInstantiated() {
                return true;
            }

            @Override
            public void deserialize(Float o, Fields f) throws StreamCorruptedException {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }

            @Override
            @Nullable
            public Float deserialize(String s) {
                try {
                    return Float.valueOf(Float.parseFloat(s));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }

            @Override
            public boolean mustSyncDeserialization() {
                return false;
            }
        }).math(Number.class, new NumberArithmetic()));
        Classes.registerClass(new ClassInfo<Boolean>(Boolean.class, "boolean").user("booleans?").name("Boolean").description("A boolean is a value that is either true or false. Other accepted names are 'on' and 'yes' for true, and 'off' and 'no' for false.").usage("true/yes/on or false/no/off").examples("set {config.%player%.use mod} to false").since("1.0").parser(new Parser<Boolean>(){
            private final RegexMessage truePattern = new RegexMessage("boolean.true.pattern");
            private final RegexMessage falsePattern = new RegexMessage("boolean.false.pattern");
            private final Message trueName = new Message("boolean.true.name");
            private final Message falseName = new Message("boolean.false.name");

            @Override
            @Nullable
            public Boolean parse(String s, ParseContext context) {
                if (this.truePattern.matcher(s).matches()) {
                    return Boolean.TRUE;
                }
                if (this.falsePattern.matcher(s).matches()) {
                    return Boolean.FALSE;
                }
                return null;
            }

            @Override
            public String toString(Boolean b, int flags) {
                return b != false ? this.trueName.toString() : this.falseName.toString();
            }

            @Override
            public String toVariableNameString(Boolean b) {
                return "" + b;
            }

            @Override
            public String getVariableNamePattern() {
                return "(true|false)";
            }
        }).serializer(new Serializer<Boolean>(){

            @Override
            public Fields serialize(Boolean n) {
                throw new IllegalStateException();
            }

            @Override
            public boolean canBeInstantiated() {
                return true;
            }

            @Override
            public void deserialize(Boolean o, Fields f) throws StreamCorruptedException {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }

            @Override
            @Nullable
            public Boolean deserialize(String s) {
                if (s.equals("true")) {
                    return Boolean.TRUE;
                }
                if (s.equals("false")) {
                    return Boolean.FALSE;
                }
                return null;
            }

            @Override
            public boolean mustSyncDeserialization() {
                return false;
            }
        }));
        Classes.registerClass(new ClassInfo<Short>(Short.class, "short").name(ClassInfo.NO_DOC).defaultExpression(new SimpleLiteral<Short>((short)1, true)).parser(new Parser<Short>(){

            @Override
            @Nullable
            public Short parse(String s, ParseContext context) {
                try {
                    return Short.valueOf(s);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }

            @Override
            public String toString(Short s, int flags) {
                return "" + s;
            }

            @Override
            public String toVariableNameString(Short s) {
                return "" + s;
            }

            @Override
            public String getVariableNamePattern() {
                return "-?\\d+";
            }
        }).serializer(new Serializer<Short>(){

            @Override
            public Fields serialize(Short n) {
                throw new IllegalStateException();
            }

            @Override
            public boolean canBeInstantiated() {
                return true;
            }

            @Override
            public void deserialize(Short o, Fields f) throws StreamCorruptedException {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }

            @Override
            @Nullable
            public Short deserialize(String s) {
                try {
                    return Short.parseShort(s);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }

            @Override
            public boolean mustSyncDeserialization() {
                return false;
            }
        }).math(Number.class, new NumberArithmetic()));
        Classes.registerClass(new ClassInfo<Byte>(Byte.class, "byte").name(ClassInfo.NO_DOC).defaultExpression(new SimpleLiteral<Byte>((byte)1, true)).parser(new Parser<Byte>(){

            @Override
            @Nullable
            public Byte parse(String s, ParseContext context) {
                try {
                    return Byte.valueOf(s);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }

            @Override
            public String toString(Byte b, int flags) {
                return "" + b;
            }

            @Override
            public String toVariableNameString(Byte b) {
                return "" + b;
            }

            @Override
            public String getVariableNamePattern() {
                return "-?\\d+";
            }
        }).serializer(new Serializer<Byte>(){

            @Override
            public Fields serialize(Byte n) {
                throw new IllegalStateException();
            }

            @Override
            public boolean canBeInstantiated() {
                return true;
            }

            @Override
            public void deserialize(Byte o, Fields f) throws StreamCorruptedException {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }

            @Override
            @Nullable
            public Byte deserialize(String s) {
                try {
                    return Byte.parseByte(s);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }

            @Override
            public boolean mustSyncDeserialization() {
                return false;
            }
        }).math(Number.class, new NumberArithmetic()));
        Classes.registerClass(new ClassInfo<String>(String.class, "string").user("(text|string)s?").name("Text").description("Text is simply text, i.e. a sequence of characters, which can optionally contain expressions which will be replaced with a meaningful representation (e.g. %player% will be replaced with the player's name).", "Because scripts are also text, you have to put text into double quotes to tell Skript which part of the line is an effect/expression and which part is the text.", "Please read the article on <a href='../strings/'>Texts and Variable Names</a> to learn more.").usage("simple: \"...\"", "quotes: \"...\"\"...\"", "expressions: \"...%expression%...\"", "percent signs: \"...%%...\"").examples("broadcast \"Hello World!\"", "message \"Hello %player%\"", "message \"The id of \"\"%type of tool%\"\" is %id of tool%.\"").since("1.0").parser(new Parser<String>(){

            @Override
            @Nullable
            public String parse(String s, ParseContext context) {
                switch (context) {
                    case DEFAULT: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        return null;
                    }
                    case CONFIG: {
                        return s;
                    }
                    case EVENT: 
                    case SCRIPT: {
                        if (VariableString.isQuotedCorrectly(s, true)) {
                            return Utils.replaceChatStyles(s.substring(1, s.length() - 1).replace("\"\"", "\""));
                        }
                        return null;
                    }
                    case COMMAND: {
                        return s;
                    }
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return null;
            }

            @Override
            public boolean canParse(ParseContext context) {
                return context != ParseContext.DEFAULT;
            }

            @Override
            public String toString(String s, int flags) {
                return s;
            }

            @Override
            public String getDebugMessage(String s) {
                return String.valueOf('\"') + s + '\"';
            }

            @Override
            public String toVariableNameString(String s) {
                return s;
            }

            @Override
            public String getVariableNamePattern() {
                return ".*";
            }
        }).serializer(new Serializer<String>(){

            @Override
            public Fields serialize(String n) {
                throw new IllegalStateException();
            }

            @Override
            public boolean canBeInstantiated() {
                return true;
            }

            @Override
            public void deserialize(String o, Fields f) throws StreamCorruptedException {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }

            @Override
            public String deserialize(String s) {
                return s;
            }

            @Override
            public boolean mustSyncDeserialization() {
                return false;
            }
        }));
    }
}

