/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.variables;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Task;
import ch.njol.skript.util.Timespan;
import ch.njol.skript.variables.SerializedVariable;
import ch.njol.skript.variables.Variables;
import ch.njol.skript.variables.VariablesStorage;
import ch.njol.util.SynchronizedReference;
import java.io.File;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import lib.PatPeter.SQLibrary.Database;
import lib.PatPeter.SQLibrary.DatabaseException;
import lib.PatPeter.SQLibrary.MySQL;
import lib.PatPeter.SQLibrary.SQLibrary;
import lib.PatPeter.SQLibrary.SQLite;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.Nullable;

public class DatabaseStorage
extends VariablesStorage {
    public static final int MAX_VARIABLE_NAME_LENGTH = 380;
    public static final int MAX_CLASS_CODENAME_LENGTH = 50;
    public static final int MAX_VALUE_SIZE = 10000;
    private static final String OLD_TABLE_NAME = "variables";
    private static final String SELECT_ORDER = "name, type, value, rowid";
    private final Type type;
    private String tableName;
    @Nullable
    private String formattedCreateQuery;
    final SynchronizedReference<Database> db = new SynchronizedReference<Object>(null);
    private boolean monitor = false;
    long monitor_interval;
    private static final String guid = UUID.randomUUID().toString();
    private static final long TRANSACTION_DELAY = 500L;
    @Nullable
    private PreparedStatement writeQuery;
    @Nullable
    private PreparedStatement deleteQuery;
    @Nullable
    private PreparedStatement monitorQuery;
    @Nullable
    PreparedStatement monitorCleanUpQuery;
    long lastRowID = -1L;

    DatabaseStorage(String name, Type type) {
        super(name);
        this.type = type;
        this.tableName = "variables21";
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Nullable
    public String getFormattedCreateQuery() {
        if (this.formattedCreateQuery == null) {
            this.formattedCreateQuery = String.format(this.type.createQuery, this.tableName);
        }
        return this.formattedCreateQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean load_i(SectionNode n) {
        SynchronizedReference<Database> synchronizedReference = this.db;
        synchronized (synchronizedReference) {
            block41: {
                Database db;
                Plugin p = Bukkit.getPluginManager().getPlugin("SQLibrary");
                if (p == null || !(p instanceof SQLibrary)) {
                    Skript.error("You need the plugin SQLibrary in order to use a database with Skript. You can download the latest version from http://dev.bukkit.org/server-mods/sqlibrary/files/");
                    return false;
                }
                Boolean monitor_changes = this.getValue(n, "monitor changes", Boolean.class);
                Timespan monitor_interval = this.getValue(n, "monitor interval", Timespan.class);
                if (monitor_changes == null || monitor_interval == null) {
                    return false;
                }
                this.monitor = monitor_changes;
                this.monitor_interval = monitor_interval.getMilliSeconds();
                try {
                    Object o = this.type.initialise(this, n);
                    if (o == null) {
                        return false;
                    }
                    db = (Database)o;
                    this.db.set(db);
                }
                catch (RuntimeException e) {
                    if (e instanceof DatabaseException) {
                        Skript.error(e.getLocalizedMessage());
                        return false;
                    }
                    throw e;
                }
                SkriptLogger.setNode(null);
                if (!this.connect(true)) {
                    return false;
                }
                try {
                    boolean hasOldTable = db.isTable(OLD_TABLE_NAME);
                    boolean hadNewTable = db.isTable(this.getTableName());
                    if (this.getFormattedCreateQuery() == null) {
                        Skript.error("Could not create the variables table in the database. The query to create the variables table '" + this.tableName + "' in the database '" + this.databaseName + "' is null.");
                        return false;
                    }
                    try {
                        db.query(this.getFormattedCreateQuery());
                    }
                    catch (SQLException e) {
                        Skript.error("Could not create the variables table '" + this.tableName + "' in the database '" + this.databaseName + "': " + e.getLocalizedMessage() + ". " + "Please create the table yourself using the following query: " + String.format(this.type.createQuery, this.tableName).replace(",", ", ").replaceAll("\\s+", " "));
                        return false;
                    }
                    if (!this.prepareQueries()) {
                        return false;
                    }
                    if (hasOldTable && !this.tableName.equals(OLD_TABLE_NAME)) {
                        ResultSet r1 = db.query("SELECT name, type, value, rowid FROM variables");
                        assert (r1 != null);
                        try {
                            this.oldLoadVariables(r1, hadNewTable);
                        }
                        finally {
                            r1.close();
                        }
                    }
                    ResultSet r2 = db.query("SELECT name, type, value, rowid FROM " + this.getTableName());
                    assert (r2 != null);
                    try {
                        this.loadVariables(r2);
                    }
                    finally {
                        r2.close();
                    }
                    if (!hasOldTable) break block41;
                    if (!hadNewTable) {
                        Skript.info("[2.1] Updating the database '" + this.databaseName + "' to the new format...");
                        try {
                            Variables.getReadLock().lock();
                            Iterator<Map.Entry<String, Object>> iterator = Variables.getVariablesHashMap().entrySet().iterator();
                            while (true) {
                                if (!iterator.hasNext()) {
                                    Skript.info("Updated and transferred " + Variables.getVariablesHashMap().size() + " variables to the new table.");
                                    break;
                                }
                                Map.Entry<String, Object> v = iterator.next();
                                if (!this.accept(v.getKey())) continue;
                                SerializedVariable var = Variables.serialize(v.getKey(), v.getValue());
                                SerializedVariable.Value d = var.value;
                                this.save(var.name, d == null ? null : d.type, d == null ? null : d.data);
                            }
                        }
                        finally {
                            Variables.getReadLock().unlock();
                        }
                    }
                    db.query("DELETE FROM variables WHERE value IS NULL");
                    db.query("DELETE FROM old USING variables AS old, " + this.getTableName() + " AS new WHERE old.name = new.name");
                    try (ResultSet r = db.query("SELECT * FROM variables LIMIT 1");){
                        if (r.next()) {
                            Skript.error("Could not successfully convert & transfer all variables to the new table in the database '" + this.databaseName + "'. " + "Variables that could not be transferred are left in the old table and Skript will reattempt to transfer them whenever it starts until the old table is empty or is manually deleted. " + "Please note that variables recreated by scripts will count as converted and will be removed from the old table on the next restart.");
                            break block41;
                        }
                        boolean error = false;
                        try {
                            this.disconnect();
                            this.connect();
                            db.query("DROP TABLE variables");
                        }
                        catch (SQLException e) {
                            Skript.error("There was an error deleting the old variables table from the database '" + this.databaseName + "', please delete it yourself: " + e.getLocalizedMessage());
                            error = true;
                        }
                        if (!error) {
                            Skript.info("Successfully deleted the old variables table from the database '" + this.databaseName + "'.");
                        }
                        if (!hadNewTable) {
                            Skript.info("Database '" + this.databaseName + "' successfully updated.");
                        }
                    }
                }
                catch (SQLException e) {
                    this.sqlException(e);
                    return false;
                }
            }
            Skript.newThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (!DatabaseStorage.this.closed) {
                        SynchronizedReference<Database> synchronizedReference = DatabaseStorage.this.db;
                        synchronized (synchronizedReference) {
                            try {
                                Database db = DatabaseStorage.this.db.get();
                                if (db != null) {
                                    db.query("SELECT * FROM " + DatabaseStorage.this.getTableName() + " LIMIT 1");
                                }
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                        }
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }, "Skript database '" + this.databaseName + "' connection keep-alive thread").start();
            return true;
        }
    }

    @Override
    protected void allLoaded() {
        Skript.debug("Database " + this.databaseName + " loaded. Queue size = " + this.changesQueue.size());
        Skript.newThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!DatabaseStorage.this.closed) {
                    long lastCommit;
                    SynchronizedReference<Database> synchronizedReference = DatabaseStorage.this.db;
                    synchronized (synchronizedReference) {
                        Database db = DatabaseStorage.this.db.get();
                        try {
                            if (db != null) {
                                db.getConnection().commit();
                            }
                        }
                        catch (SQLException e) {
                            DatabaseStorage.this.sqlException(e);
                        }
                        lastCommit = System.currentTimeMillis();
                    }
                    try {
                        Thread.sleep(Math.max(0L, lastCommit + 500L - System.currentTimeMillis()));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }, "Skript database '" + this.databaseName + "' transaction committing thread").start();
        if (this.monitor) {
            Skript.newThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(DatabaseStorage.this.monitor_interval);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    long lastWarning = Long.MIN_VALUE;
                    int WARING_INTERVAL = 10;
                    while (!DatabaseStorage.this.closed) {
                        long next = System.currentTimeMillis() + DatabaseStorage.this.monitor_interval;
                        DatabaseStorage.this.checkDatabase();
                        long now = System.currentTimeMillis();
                        if (next < now && lastWarning + 10000L < now) {
                            Skript.warning("Cannot load variables from the database fast enough (loading took " + (double)(now - next + DatabaseStorage.this.monitor_interval) / 1000.0 + "s, monitor interval = " + (double)DatabaseStorage.this.monitor_interval / 1000.0 + "s). " + "Please increase your monitor interval or reduce usage of variables. " + "(this warning will be repeated at most once every " + 10 + " seconds)");
                            lastWarning = now;
                        }
                        while (System.currentTimeMillis() < next) {
                            try {
                                Thread.sleep(next - System.currentTimeMillis());
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }, "Skript database '" + this.databaseName + "' monitor thread").start();
        }
    }

    @Override
    protected boolean requiresFile() {
        return this.type == Type.SQLITE;
    }

    @Override
    protected File getFile(String file) {
        if (!file.endsWith(".db")) {
            file = String.valueOf(file) + ".db";
        }
        return new File(file);
    }

    @Override
    protected boolean connect() {
        return this.connect(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean connect(boolean first) {
        SynchronizedReference<Database> synchronizedReference = this.db;
        synchronized (synchronizedReference) {
            Database db;
            block9: {
                db = this.db.get();
                if (db != null && db.open()) break block9;
                if (first) {
                    Skript.error("Cannot connect to the database '" + this.databaseName + "'! Please make sure that all settings are correct" + (this.type == Type.MYSQL ? " and that the database software is running" : "") + ".");
                } else {
                    Skript.exception("Cannot reconnect to the database '" + this.databaseName + "'!");
                }
                return false;
            }
            try {
                db.getConnection().setAutoCommit(false);
            }
            catch (SQLException e) {
                this.sqlException(e);
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean prepareQueries() {
        SynchronizedReference<Database> synchronizedReference = this.db;
        synchronized (synchronizedReference) {
            Database db = this.db.get();
            assert (db != null);
            try {
                try {
                    if (this.writeQuery != null) {
                        this.writeQuery.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.writeQuery = db.prepare("REPLACE INTO " + this.getTableName() + " (name, type, value, update_guid) VALUES (?, ?, ?, ?)");
                try {
                    if (this.deleteQuery != null) {
                        this.deleteQuery.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.deleteQuery = db.prepare("DELETE FROM " + this.getTableName() + " WHERE name = ?");
                try {
                    if (this.monitorQuery != null) {
                        this.monitorQuery.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.monitorQuery = db.prepare("SELECT name, type, value, rowid FROM " + this.getTableName() + " WHERE rowid > ? AND update_guid != ?");
                try {
                    if (this.monitorCleanUpQuery != null) {
                        this.monitorCleanUpQuery.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.monitorCleanUpQuery = db.prepare("DELETE FROM " + this.getTableName() + " WHERE value IS NULL AND rowid < ?");
            }
            catch (SQLException e) {
                Skript.exception((Throwable)e, "Could not prepare queries for the database '" + this.databaseName + "': " + e.getLocalizedMessage());
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void disconnect() {
        SynchronizedReference<Database> synchronizedReference = this.db;
        synchronized (synchronizedReference) {
            Database db = this.db.get();
            if (db != null) {
                db.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean save(String name, @Nullable String type, @Nullable byte[] value) {
        SynchronizedReference<Database> synchronizedReference = this.db;
        synchronized (synchronizedReference) {
            if (name.length() > 380) {
                Skript.error("The name of the variable {" + name + "} is too long to be saved in a database (length: " + name.length() + ", maximum allowed: " + 380 + ")! It will be truncated and won't bet available under the same name again when loaded.");
            }
            if (value != null && value.length > 10000) {
                Skript.error("The variable {" + name + "} cannot be saved in the database as its value's size (" + value.length + ") exceeds the maximum allowed size of " + 10000 + "! An attempt to save the variable will be made nonetheless.");
            }
            try {
                if (type == null) {
                    assert (value == null);
                    PreparedStatement deleteQuery = this.deleteQuery;
                    assert (deleteQuery != null);
                    deleteQuery.setString(1, name);
                    deleteQuery.executeUpdate();
                } else {
                    int i = 1;
                    PreparedStatement writeQuery = this.writeQuery;
                    assert (writeQuery != null);
                    writeQuery.setString(i++, name);
                    writeQuery.setString(i++, type);
                    writeQuery.setBytes(i++, value);
                    writeQuery.setString(i++, guid);
                    writeQuery.executeUpdate();
                }
            }
            catch (SQLException e) {
                this.sqlException(e);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        SynchronizedReference<Database> synchronizedReference = this.db;
        synchronized (synchronizedReference) {
            super.close();
            Database db = this.db.get();
            if (db != null) {
                try {
                    db.getConnection().commit();
                }
                catch (SQLException e) {
                    this.sqlException(e);
                }
                db.close();
                this.db.set(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkDatabase() {
        try {
            long lastRowID;
            try (ResultSet r = null;){
                SynchronizedReference<Database> synchronizedReference = this.db;
                synchronized (synchronizedReference) {
                    block15: {
                        if (!this.closed && this.db.get() != null) break block15;
                        return;
                    }
                    lastRowID = this.lastRowID;
                    PreparedStatement monitorQuery = this.monitorQuery;
                    assert (monitorQuery != null);
                    monitorQuery.setLong(1, lastRowID);
                    monitorQuery.setString(2, guid);
                    monitorQuery.execute();
                    r = monitorQuery.getResultSet();
                    assert (r != null);
                }
                if (!this.closed) {
                    this.loadVariables(r);
                }
            }
            if (!this.closed) {
                new Task((Plugin)Skript.getInstance(), (long)Math.ceil(2.0 * (double)this.monitor_interval / 50.0) + 100L, true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            SynchronizedReference<Database> synchronizedReference = DatabaseStorage.this.db;
                            synchronized (synchronizedReference) {
                                if (DatabaseStorage.this.closed || DatabaseStorage.this.db.get() == null) {
                                    return;
                                }
                                PreparedStatement monitorCleanUpQuery = DatabaseStorage.this.monitorCleanUpQuery;
                                if (!$assertionsDisabled && monitorCleanUpQuery == null) {
                                    throw new AssertionError();
                                }
                                monitorCleanUpQuery.setLong(1, lastRowID);
                                monitorCleanUpQuery.executeUpdate();
                            }
                        }
                        catch (SQLException e) {
                            DatabaseStorage.this.sqlException(e);
                        }
                    }
                };
            }
        }
        catch (SQLException e) {
            this.sqlException(e);
        }
    }

    private void loadVariables(final ResultSet r) throws SQLException {
        SQLException e = Task.callSync(new Callable<SQLException>(){

            @Override
            @Nullable
            public SQLException call() throws Exception {
                try {
                    while (r.next()) {
                        Serializer<?> s;
                        String name;
                        int i = 1;
                        if ((name = r.getString(i++)) == null) {
                            Skript.error("Variable with NULL name found in the database '" + DatabaseStorage.this.databaseName + "', ignoring it");
                            continue;
                        }
                        String type = r.getString(i++);
                        byte[] value = r.getBytes(i++);
                        DatabaseStorage.this.lastRowID = r.getLong(i++);
                        if (value == null) {
                            Variables.variableLoaded(name, null, DatabaseStorage.this);
                            continue;
                        }
                        ClassInfo<?> c = Classes.getClassInfoNoError(type);
                        if (c == null || (s = c.getSerializer()) == null) {
                            Skript.error("Cannot load the variable {" + name + "} from the database '" + DatabaseStorage.this.databaseName + "', because the type '" + type + "' cannot be recognised or cannot be stored in variables");
                            continue;
                        }
                        Object d = Classes.deserialize(c, value);
                        if (d == null) {
                            Skript.error("Cannot load the variable {" + name + "} from the database '" + DatabaseStorage.this.databaseName + "', because it cannot be loaded as " + c.getName().withIndefiniteArticle());
                            continue;
                        }
                        Variables.variableLoaded(name, d, DatabaseStorage.this);
                    }
                }
                catch (SQLException e) {
                    return e;
                }
                return null;
            }
        });
        if (e != null) {
            throw e;
        }
    }

    @Deprecated
    private void oldLoadVariables(final ResultSet r, final boolean hadNewTable) throws SQLException {
        final VariablesStorage temp = new VariablesStorage(String.valueOf(this.databaseName) + " old variables table"){

            @Override
            protected boolean save(String name, @Nullable String type, @Nullable byte[] value) {
                if (!$assertionsDisabled && type != null) {
                    throw new AssertionError((Object)(String.valueOf(name) + "; " + type));
                }
                return true;
            }

            @Override
            boolean accept(@Nullable String var) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return false;
            }

            @Override
            protected boolean requiresFile() {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return false;
            }

            @Override
            protected boolean load_i(SectionNode n) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return false;
            }

            @Override
            protected File getFile(String file) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return new File(file);
            }

            @Override
            protected void disconnect() {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }

            @Override
            protected boolean connect() {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return false;
            }

            @Override
            protected void allLoaded() {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
        };
        SQLException e = Task.callSync(new Callable<SQLException>(){

            @Override
            @Nullable
            public SQLException call() throws Exception {
                try {
                    while (r.next()) {
                        Serializer<?> s;
                        String name;
                        int i = 1;
                        if ((name = r.getString(i++)) == null) {
                            Skript.error("Variable with NULL name found in the database, ignoring it");
                            continue;
                        }
                        String type = r.getString(i++);
                        String value = r.getString(i++);
                        DatabaseStorage.this.lastRowID = r.getLong(i++);
                        if (type == null || value == null) {
                            Variables.variableLoaded(name, null, hadNewTable ? temp : DatabaseStorage.this);
                            continue;
                        }
                        ClassInfo<?> c = Classes.getClassInfoNoError(type);
                        if (c == null || (s = c.getSerializer()) == null) {
                            Skript.error("Cannot load the variable {" + name + "} from the database, because the type '" + type + "' cannot be recognised or not stored in variables");
                            continue;
                        }
                        Object d = s.deserialize(value);
                        if (d == null) {
                            Skript.error("Cannot load the variable {" + name + "} from the database, because '" + value + "' cannot be parsed as a " + type);
                            continue;
                        }
                        Variables.variableLoaded(name, d, DatabaseStorage.this);
                    }
                }
                catch (SQLException e) {
                    return e;
                }
                return null;
            }
        });
        if (e != null) {
            throw e;
        }
    }

    void sqlException(SQLException e) {
        Skript.error("database error: " + e.getLocalizedMessage());
        if (Skript.testing()) {
            e.printStackTrace();
        }
        this.prepareQueries();
    }

    public static abstract class Type
    extends Enum<Type> {
        public static final /* enum */ Type MYSQL = new Type("CREATE TABLE IF NOT EXISTS %s (rowid        BIGINT  NOT NULL  AUTO_INCREMENT  PRIMARY KEY,name         VARCHAR(380)  NOT NULL  UNIQUE,type         VARCHAR(50),value        BLOB(10000),update_guid  CHAR(36)  NOT NULL) CHARACTER SET ucs2 COLLATE ucs2_bin"){

            @Override
            @Nullable
            protected Object initialise(DatabaseStorage s, SectionNode n) {
                String host = s.getValue(n, "host");
                Integer port = s.getValue(n, "port", Integer.class);
                String user = s.getValue(n, "user");
                String password = s.getValue(n, "password");
                String database = s.getValue(n, "database");
                s.setTableName(n.get("table", "variables21"));
                if (host == null || port == null || user == null || password == null || database == null) {
                    return null;
                }
                return new MySQL(SkriptLogger.LOGGER, "[Skript]", host, port.intValue(), database, user, password);
            }
        };
        public static final /* enum */ Type SQLITE = new Type("CREATE TABLE IF NOT EXISTS %s (name         VARCHAR(380)  NOT NULL  PRIMARY KEY,type         VARCHAR(50),value        BLOB(10000),update_guid  CHAR(36)  NOT NULL)"){

            @Override
            @Nullable
            protected Object initialise(DatabaseStorage s, SectionNode config) {
                File f = s.file;
                if (f == null) {
                    return null;
                }
                s.setTableName(config.get("table", "variables21"));
                String name = f.getName();
                if (!$assertionsDisabled && !name.endsWith(".db")) {
                    throw new AssertionError();
                }
                return new SQLite(SkriptLogger.LOGGER, "[Skript]", f.getParent(), name.substring(0, name.length() - ".db".length()));
            }
        };
        final String createQuery;
        private static final /* synthetic */ Type[] ENUM$VALUES;

        static {
            ENUM$VALUES = new Type[]{MYSQL, SQLITE};
        }

        private Type(String createQuery) {
            this.createQuery = createQuery;
        }

        @Nullable
        protected abstract Object initialise(DatabaseStorage var1, SectionNode var2);

        public static Type[] values() {
            Type[] typeArray = ENUM$VALUES;
            int n = typeArray.length;
            Type[] typeArray2 = new Type[n];
            System.arraycopy(ENUM$VALUES, 0, typeArray2, 0, n);
            return typeArray2;
        }

        public static Type valueOf(String string) {
            return Enum.valueOf(Type.class, string);
        }
    }
}

