/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.TriggerSection;
import java.io.File;
import java.util.List;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

public class Trigger
extends TriggerSection {
    private final String name;
    private final SkriptEvent event;
    @Nullable
    private final File script;
    private int line = -1;
    private String debugLabel;

    public Trigger(@Nullable File script, String name, SkriptEvent event, List<TriggerItem> items) {
        super(items);
        this.script = script;
        this.name = name;
        this.event = event;
        this.debugLabel = "unknown trigger";
    }

    public boolean execute(Event e) {
        return TriggerItem.walk(this, e);
    }

    @Override
    @Nullable
    protected TriggerItem walk(Event e) {
        return this.walk(e, true);
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return String.valueOf(this.name) + " (" + this.event.toString(e, debug) + ")";
    }

    public String getName() {
        return this.name;
    }

    public SkriptEvent getEvent() {
        return this.event;
    }

    @Nullable
    public File getScript() {
        return this.script;
    }

    public void setLineNumber(int line) {
        this.line = line;
    }

    public int getLineNumber() {
        return this.line;
    }

    public void setDebugLabel(String label) {
        this.debugLabel = label;
    }

    public String getDebugLabel() {
        return this.debugLabel;
    }
}

