/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.util.Date;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Unix Timestamp")
@Description(value={"Converts given date to Unix timestamp. This is roughly how many seconds have elapsed since 1 January 1970."})
@Examples(value={"unix timestamp of now"})
@Since(value="2.2-dev31")
public class ExprUnixTicks
extends SimplePropertyExpression<Date, Number> {
    static {
        ExprUnixTicks.register(ExprUnixTicks.class, Number.class, "unix timestamp", "dates");
    }

    @Override
    @Nullable
    public Number convert(Date f) {
        return (double)f.getTimestamp() / 1000.0;
    }

    @Override
    protected String getPropertyName() {
        return "unix timestamp";
    }

    @Override
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }
}

