/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.util.Timespan;
import org.bukkit.entity.LivingEntity;

@Name(value="Remaining Air")
@Description(value={"How much time a player has left underwater before starting to drown."})
@Examples(value={"player's remaining air is less than 3 seconds:", "\tsend \"hurry, get to the surface!\" to the player"})
@Since(value="<i>unknown</i> (before 2.1)")
public class ExprRemainingAir
extends SimplePropertyExpression<LivingEntity, Timespan> {
    static {
        ExprRemainingAir.register(ExprRemainingAir.class, Timespan.class, "remaining air", "livingentities");
    }

    @Override
    public Class<Timespan> getReturnType() {
        return Timespan.class;
    }

    @Override
    protected String getPropertyName() {
        return "remaining air";
    }

    @Override
    public Timespan convert(LivingEntity e) {
        return Timespan.fromTicks(e.getRemainingAir());
    }
}

