/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Inventory Holder/Viewers/Rows")
@Description(value={"Gets the rows/size/viewers/holder of an inventory."})
@Examples(value={"event-inventory's amount of rows", "holder of player's top inventory", "{_inventory}'s viewers"})
@Since(value="2.2-dev34")
public class ExprInventoryInfo
extends PropertyExpression<Inventory, Object> {
    private static final int HOLDER = 1;
    private static final int VIEWERS = 2;
    private static final int ROWS = 3;
    private int type;

    static {
        PropertyExpression.register(ExprInventoryInfo.class, Object.class, "(1\u00a6holder[s]|2\u00a6viewers|3\u00a6[amount of] rows)", "inventories");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        this.type = parseResult.mark;
        return true;
    }

    protected Object[] get(Event e, Inventory[] source) {
        ArrayList<? extends Object> info = new ArrayList<Object>();
        Inventory[] inventoryArray = source;
        int n = source.length;
        int n2 = 0;
        while (n2 < n) {
            Inventory inv = inventoryArray[n2];
            info.addAll(this.get(inv));
            ++n2;
        }
        return info.toArray(new Object[info.size()]);
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return this.type == 1 ? "inventory holder of " : (this.type == 2 ? "inventory viewers of " : "inventory rows of " + this.getExpr().toString(e, debug));
    }

    @Override
    public Class<? extends Object> getReturnType() {
        return this.type == 1 ? InventoryHolder.class : (this.type == 2 ? Player.class : Number.class);
    }

    private List<? extends Object> get(Inventory source) {
        switch (this.type) {
            case 1: {
                return Arrays.asList(source.getHolder());
            }
            case 2: {
                return source.getViewers();
            }
        }
        return Arrays.asList(source.getSize() / 9);
    }
}

