/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Hash")
@Description(value={"Hashes the given text using the MD5 or SHA-256 algorithms. Each algorithm is suitable for different use cases.<p>", "MD5 is provided mostly for backwards compatibility, as it is outdated and not secure. ", "SHA-256 is more secure, and can used to hash somewhat confidental data like IP addresses and even passwords. ", "It is not <i>that</i> secure out of the box, so please consider using salt when dealing with passwords! ", "When hashing data, you <strong>must</strong> specify algorithms that will be used for security reasons! ", "<p>Please note that a hash cannot be reversed under normal circumstanses. You will not be able to get original value from a hash with Skript."})
@Examples(value={"command /setpass <text>:", "\ttrigger:", "\t\tset {password.%player%} to text-argument hashed with SHA-256", "command /login <text>:", "\ttrigger:", "\t\t{password.%player%} is text-argument hashed with SHA-256:", "\t\t\tmessage \"Login successful.\"", "\t\telse:", "\t\t\tmessage \"Wrong password!\""})
@Since(value="2.0, 2.2-dev32 (SHA-256 algorithm)")
public class ExprHash
extends PropertyExpression<String, String> {
    private static final Charset UTF_8;
    @Nullable
    static MessageDigest md5;
    @Nullable
    static MessageDigest sha256;
    private int algorithm;

    static {
        Skript.registerExpression(ExprHash.class, String.class, ExpressionType.SIMPLE, "%strings% hash[ed] with (0\u00a6MD5|1\u00a6SHA-256)");
        UTF_8 = Charset.forName("UTF-8");
        try {
            md5 = MessageDigest.getInstance("MD5");
            sha256 = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalError("JVM does not adhere to Java specifications");
        }
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        this.algorithm = parseResult.mark;
        return true;
    }

    protected String[] get(Event e, String[] source) {
        assert (md5 != null);
        assert (sha256 != null);
        MessageDigest digest = null;
        if (this.algorithm == 0) {
            digest = md5;
        } else if (this.algorithm == 1) {
            digest = sha256;
        } else assert (false);
        String[] r = new String[source.length];
        int i = 0;
        while (i < r.length) {
            r[i] = ExprHash.toHex(digest.digest(source[i].getBytes(UTF_8)));
            ++i;
        }
        return r;
    }

    private static String toHex(byte[] b) {
        char[] r = new char[2 * b.length];
        int i = 0;
        while (i < b.length) {
            r[2 * i] = Character.forDigit((b[i] & 0xF0) >> 4, 16);
            r[2 * i + 1] = Character.forDigit(b[i] & 0xF, 16);
            ++i;
        }
        return new String(r);
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "hash of " + this.getExpr();
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }
}

