/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.VectorMath;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Vectors - Rotate around vector")
@Description(value={"Rotates a vector around another vector"})
@Examples(value={"rotate {_v} around vector 1, 0, 0 by 90"})
@Since(value="2.2-dev28")
public class EffVectorRotateAroundAnother
extends Effect {
    private Expression<Vector> first;
    private Expression<Vector> second;
    private Expression<Number> number;

    static {
        Skript.registerEffect(EffVectorRotateAroundAnother.class, "rotate %vectors% around %vector% by %number% [degrees]");
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "rotate " + this.first.toString(e, debug) + " around " + this.second.toString(e, debug);
    }

    @Override
    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.first = expressions[0];
        this.second = expressions[1];
        this.number = expressions[2];
        return true;
    }

    @Override
    protected void execute(Event event) {
        Vector v2 = this.second.getSingle(event);
        Number n = this.number.getSingle(event);
        if (v2 == null || n == null) {
            return;
        }
        Vector[] vectorArray = this.first.getArray(event);
        int n2 = vectorArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Vector v1 = vectorArray[n3];
            VectorMath.rot(v1, v2, n.doubleValue());
            ++n3;
        }
    }
}

