/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.Locale;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Play Sound")
@Description(value={"Plays a sound at given location for everyone or just for given players. Playing sounds from resource packs is supported."})
@Examples(value={""})
@Since(value="2.2-dev28")
public class EffPlaySound
extends Effect {
    private Expression<String> sound;
    @Nullable
    private Expression<Number> volume;
    @Nullable
    private Expression<Number> pitch;
    private Expression<Location> location;
    @Nullable
    private Expression<Player> players;
    private boolean useCategory;

    static {
        Skript.registerEffect(EffPlaySound.class, "play sound %string% [with volume %number%] [(and|with) pitch %number%] at %location% [for %players%]");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.sound = exprs[0];
        this.volume = exprs[1];
        this.pitch = exprs[2];
        this.location = exprs[3];
        this.players = exprs[4];
        this.useCategory = Skript.classExists("org.bukkit.SoundCategory");
        return true;
    }

    @Override
    protected void execute(Event e) {
        Location l = this.location.getSingle(e);
        Sound soundEnum = null;
        String s = this.sound.getSingle(e);
        if (s != null) {
            float vol = this.volume != null ? this.volume.getSingle(e).floatValue() : 0.0f;
            float pi = this.pitch != null ? this.pitch.getSingle(e).floatValue() : 0.0f;
            try {
                soundEnum = Sound.valueOf((String)s.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (this.players != null) {
                if (soundEnum == null) {
                    Player[] playerArray = this.players.getAll(e);
                    int n = playerArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Player p = playerArray[n2];
                        if (this.useCategory) {
                            p.playSound(l, s, SoundCategory.MASTER, vol, pi);
                        } else {
                            p.playSound(l, s, vol, pi);
                        }
                        ++n2;
                    }
                } else {
                    Player[] playerArray = this.players.getAll(e);
                    int n = playerArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Player p = playerArray[n3];
                        if (this.useCategory) {
                            p.playSound(l, soundEnum, SoundCategory.MASTER, vol, pi);
                        } else {
                            p.playSound(l, soundEnum, vol, pi);
                        }
                        ++n3;
                    }
                }
            } else if (soundEnum == null) {
                l.getWorld().playSound(l, s, vol, pi);
            } else {
                l.getWorld().playSound(l, soundEnum, vol, pi);
            }
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        if (e != null) {
            return "play sound " + this.sound.getSingle(e);
        }
        return "play sound";
    }
}

