/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Is Wearing")
@Description(value={"Checks whether a player is wearing some armour."})
@Examples(value={"player is wearing an iron chestplate and iron leggings", "player is wearing all diamond armour"})
@Since(value="1.0")
public class CondIsWearing
extends Condition {
    private Expression<LivingEntity> entities;
    Expression<ItemType> types;

    static {
        Skript.registerCondition(CondIsWearing.class, "%livingentities% (is|are) wearing %itemtypes%", "%livingentities% (isn't|is not|aren't|are not) wearing %itemtypes%");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entities = vars[0];
        this.types = vars[1];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    @Override
    public boolean check(final Event e) {
        return this.entities.check(e, new Checker<LivingEntity>(){

            @Override
            public boolean check(final LivingEntity en) {
                return CondIsWearing.this.types.check(e, new Checker<ItemType>(){

                    @Override
                    public boolean check(ItemType t) {
                        ItemStack[] itemStackArray = en.getEquipment().getArmorContents();
                        int n = itemStackArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ItemStack is = itemStackArray[n2];
                            if (t.isOfType(is) ^ t.isAll()) {
                                return !t.isAll();
                            }
                            ++n2;
                        }
                        return t.isAll();
                    }
                }, CondIsWearing.this.isNegated());
            }
        });
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return String.valueOf(this.entities.toString(e, debug)) + (this.entities.isSingle() ? " is" : " are") + (this.isNegated() ? "not " : "") + " wearing " + this.types;
    }
}

