/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="All Permissions")
@Description(value={"Gets all permissions of players. Note that the modifications to resulting list do not actually change permissions."})
@Examples(value={""})
@Since(value="2.2-dev33")
public class ExprPermissions
extends SimpleExpression<String> {
    private Expression<Player> player;

    static {
        Skript.registerExpression(ExprPermissions.class, String.class, ExpressionType.PROPERTY, "[(all [of]|[the])] permissions of %players%", "%players%'[s] permissions");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.player = exprs[0];
        return true;
    }

    protected String[] get(Event e) {
        Player[] players = this.player.getAll(e);
        ArrayList<String> perms = new ArrayList<String>();
        Player[] playerArray = players;
        int n = players.length;
        int n2 = 0;
        while (n2 < n) {
            Player player = playerArray[n2];
            for (PermissionAttachmentInfo permissionAttachmentInfo : player.getEffectivePermissions()) {
                perms.add(permissionAttachmentInfo.getPermission());
            }
            ++n2;
        }
        return perms.toArray(new String[0]);
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        return "all permissions of " + this.player.toString();
    }
}

