/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Vectors - Location vector offset")
@Description(value={"Offset a location by a vector"})
@Examples(value={"set {_loc} to {_loc} ~ {_v}"})
@Since(value="2.2-dev28")
public class ExprLocationVectorOffset
extends SimpleExpression<Location> {
    private Expression<Location> location;
    private Expression<Vector> vectors;

    static {
        Skript.registerExpression(ExprLocationVectorOffset.class, Location.class, ExpressionType.SIMPLE, "%location%[ ]~[~][ ]%vectors%");
    }

    protected Location[] get(Event event) {
        Location l = this.location.getSingle(event);
        if (l == null) {
            return null;
        }
        Location clone = l.clone();
        Vector[] vectorArray = this.vectors.getArray(event);
        int n = vectorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Vector v = vectorArray[n2];
            clone.add(v);
            ++n2;
        }
        return new Location[]{clone};
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends Location> getReturnType() {
        return Location.class;
    }

    @Override
    public String toString(@Nullable Event event, boolean b) {
        return String.valueOf(this.location.toString()) + " offset by vector " + this.vectors.toString();
    }

    @Override
    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.location = expressions[0];
        this.vectors = expressions[1];
        return true;
    }
}

