/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.command.ScriptCommand;
import ch.njol.skript.command.ScriptCommandEvent;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Cooldown Time/Remaining Time/Elapsed Time/Cooldown Bypass Permission")
@Description(value={"Only usable in command events. Represents the cooldown time, the remaining time, or elapsed time (time since last execution), or the cooldown bypass permission."})
@Examples(value={"command /home:", "\tcooldown: 10 seconds", "\tcooldown message: You last teleported home %elapsed time% ago, you may teleport home again in %remaining time%", "\ttrigger:", "\t\tteleport player to {home::%player%}"})
@Since(value="INSERT VERSION")
public class ExprCmdElapsedRemainingTime
extends SimpleExpression<Object> {
    private int mark;

    static {
        Skript.registerExpression(ExprCmdElapsedRemainingTime.class, Object.class, ExpressionType.SIMPLE, "[the] (0\u00a6remaining|1\u00a6elapsed|2\u00a6cooldown|3\u00a6cooldown bypass perm[ission]) [time][ ][span] [of] [the] [(cooldown|wait)] [((of|for)[the] [current] command)]");
    }

    @Override
    @Nullable
    protected Object[] get(Event e) {
        if (!(e instanceof ScriptCommandEvent)) {
            return null;
        }
        ScriptCommandEvent event = (ScriptCommandEvent)e;
        ScriptCommand scriptCommand = event.getSkriptCommand();
        CommandSender sender = event.getSender();
        if (scriptCommand.getCooldown() == null || !(sender instanceof Player)) {
            return null;
        }
        Player player = (Player)event.getSender();
        UUID uuid = player.getUniqueId();
        switch (this.mark) {
            case 0: 
            case 1: {
                long ms = this.mark == 1 ? scriptCommand.getRemainingMilliseconds(uuid) : scriptCommand.getElapsedMilliseconds(uuid);
                return new Timespan[]{new Timespan(ms)};
            }
            case 2: {
                return new Timespan[]{scriptCommand.getCooldown()};
            }
            case 3: {
                return new String[]{scriptCommand.getCooldownBypass()};
            }
        }
        return null;
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<?> getReturnType() {
        return this.mark <= 2 ? Timespan.class : String.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "the " + this.getExpressionName();
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.mark = parseResult.mark;
        if (!ScriptLoader.isCurrentEvent(ScriptCommandEvent.class)) {
            Skript.error("The expression '" + this.getExpressionName() + " time' can only be used within a command", ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        return true;
    }

    @Nullable
    private String getExpressionName() {
        switch (this.mark) {
            case 0: {
                return "remaining time";
            }
            case 1: {
                return "elapsed time";
            }
            case 2: {
                return "cooldown";
            }
            case 3: {
                return "cooldown bypass permission";
            }
        }
        return null;
    }
}

