/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.classes.data;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Comparator;
import ch.njol.skript.entity.BoatData;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.registrations.Comparators;
import ch.njol.skript.util.Date;
import ch.njol.skript.util.PotionEffectUtils;
import ch.njol.skript.util.Slot;
import ch.njol.skript.util.StructureType;
import ch.njol.skript.util.Time;
import ch.njol.skript.util.Timeperiod;
import ch.njol.skript.util.Timespan;
import ch.njol.util.StringUtils;
import ch.njol.util.coll.CollectionUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Egg;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.Wither;
import org.bukkit.entity.WitherSkull;
import org.bukkit.entity.minecart.ExplosiveMinecart;
import org.bukkit.entity.minecart.HopperMinecart;
import org.bukkit.entity.minecart.PoweredMinecart;
import org.bukkit.entity.minecart.RideableMinecart;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;

public class DefaultComparators {
    static final LinkedHashMap<Class<? extends Entity>, Material> entityMaterials;
    public static final Comparator<EntityData, ItemType> entityItemComparator;

    static {
        Comparators.registerComparator(Number.class, Number.class, new Comparator<Number, Number>(){

            @Override
            public Comparator.Relation compare(Number n1, Number n2) {
                if (n1 instanceof Long && n2 instanceof Long) {
                    return Comparator.Relation.get(n1.longValue() - n2.longValue());
                }
                Double d1 = n1.doubleValue();
                Double d2 = n2.doubleValue();
                if (d1.isNaN() || d2.isNaN()) {
                    return Comparator.Relation.SMALLER;
                }
                if (d1.isInfinite() || d2.isInfinite()) {
                    return d1 > d2 ? Comparator.Relation.GREATER : (d1 < d2 ? Comparator.Relation.SMALLER : Comparator.Relation.EQUAL);
                }
                double diff = d1 - d2;
                if (Math.abs(diff) < 1.0E-10) {
                    return Comparator.Relation.EQUAL;
                }
                return Comparator.Relation.get(diff);
            }

            @Override
            public boolean supportsOrdering() {
                return true;
            }
        });
        Comparators.registerComparator(Slot.class, Slot.class, new Comparator<Slot, Slot>(){

            @Override
            public Comparator.Relation compare(Slot o1, Slot o2) {
                if (o1.isSameSlot(o2)) {
                    return Comparator.Relation.EQUAL;
                }
                return Comparator.Relation.NOT_EQUAL;
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        Comparators.registerComparator(ItemStack.class, ItemType.class, new Comparator<ItemStack, ItemType>(){

            @Override
            public Comparator.Relation compare(ItemStack is, ItemType it) {
                return Comparator.Relation.get(it.isOfType(is));
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        Comparators.registerComparator(Block.class, ItemType.class, new Comparator<Block, ItemType>(){

            @Override
            public Comparator.Relation compare(Block b, ItemType it) {
                return Comparator.Relation.get(it.isOfType(b));
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        Comparators.registerComparator(ItemType.class, ItemType.class, new Comparator<ItemType, ItemType>(){

            @Override
            public Comparator.Relation compare(ItemType i1, ItemType i2) {
                return Comparator.Relation.get(i2.isSupertypeOf(i1));
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        Comparators.registerComparator(Block.class, Block.class, new Comparator<Block, Block>(){

            @Override
            public Comparator.Relation compare(Block b1, Block b2) {
                return Comparator.Relation.get(b1.equals(b2));
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        Comparators.registerComparator(Entity.class, EntityData.class, new Comparator<Entity, EntityData>(){

            @Override
            public Comparator.Relation compare(Entity e, EntityData t) {
                return Comparator.Relation.get(t.isInstance(e));
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        Comparators.registerComparator(EntityData.class, EntityData.class, new Comparator<EntityData, EntityData>(){

            @Override
            public Comparator.Relation compare(EntityData t1, EntityData t2) {
                return Comparator.Relation.get(t2.isSupertypeOf(t1));
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        entityMaterials = new LinkedHashMap();
        entityMaterials.put(Boat.class, Material.BOAT);
        entityMaterials.put(Painting.class, Material.PAINTING);
        entityMaterials.put(Arrow.class, Material.ARROW);
        entityMaterials.put(Egg.class, Material.EGG);
        entityMaterials.put(Chicken.class, Material.RAW_CHICKEN);
        entityMaterials.put(EnderPearl.class, Material.ENDER_PEARL);
        entityMaterials.put(Snowball.class, Material.SNOW_BALL);
        entityMaterials.put(ThrownExpBottle.class, Material.EXP_BOTTLE);
        entityMaterials.put(TNTPrimed.class, Material.TNT);
        entityMaterials.put(Slime.class, Material.SLIME_BALL);
        if (Skript.classExists("org.bukkit.entity.ItemFrame")) {
            entityMaterials.put(ItemFrame.class, Material.ITEM_FRAME);
        }
        if (Skript.classExists("org.bukkit.entity.Firework")) {
            entityMaterials.put(Firework.class, Material.FIREWORK);
        }
        if (Skript.classExists("org.bukkit.entity.minecart.StorageMinecart")) {
            entityMaterials.put(StorageMinecart.class, Material.STORAGE_MINECART);
            entityMaterials.put(PoweredMinecart.class, Material.POWERED_MINECART);
            entityMaterials.put(RideableMinecart.class, Material.MINECART);
            entityMaterials.put(HopperMinecart.class, Material.HOPPER_MINECART);
            entityMaterials.put(ExplosiveMinecart.class, Material.EXPLOSIVE_MINECART);
            entityMaterials.put(Minecart.class, Material.MINECART);
        } else {
            try {
                Class<?> storageCart = Class.forName("org.bukkit.entity.StorageMinecart");
                entityMaterials.put(storageCart, Material.STORAGE_MINECART);
                Class<?> poweredCart = Class.forName("org.bukkit.entity.PoweredMinecart");
                entityMaterials.put(poweredCart, Material.POWERED_MINECART);
                entityMaterials.put(Minecart.class, Material.MINECART);
            }
            catch (ClassNotFoundException e) {
                Skript.exception((Throwable)e, "Cannot initialize material support for minecarts");
            }
        }
        if (Skript.classExists("org.bukkit.entity.ArmorStand")) {
            entityMaterials.put(ArmorStand.class, Material.ARMOR_STAND);
        }
        entityItemComparator = new Comparator<EntityData, ItemType>(){

            @Override
            public Comparator.Relation compare(EntityData e, ItemType i) {
                if (e instanceof Item) {
                    return Comparator.Relation.get(i.isOfType(((Item)e).getItemStack()));
                }
                if (e instanceof ThrownPotion) {
                    return Comparator.Relation.get(i.isOfType(Material.POTION.getId(), PotionEffectUtils.guessData((ThrownPotion)e)));
                }
                if (Skript.classExists("org.bukkit.entity.WitherSkull") && e instanceof WitherSkull) {
                    return Comparator.Relation.get(i.isOfType(Material.SKULL_ITEM.getId(), (short)1));
                }
                if (e instanceof BoatData) {
                    return Comparator.Relation.get(((BoatData)e).isOfItemType(i));
                }
                if (entityMaterials.containsKey(e.getType())) {
                    return Comparator.Relation.get(i.isOfType(entityMaterials.get(e.getType()).getId(), (short)0));
                }
                for (Map.Entry<Class<? extends Entity>, Material> m : entityMaterials.entrySet()) {
                    if (!m.getKey().isAssignableFrom(e.getType())) continue;
                    return Comparator.Relation.get(i.isOfType(m.getValue().getId(), (short)0));
                }
                return Comparator.Relation.NOT_EQUAL;
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        };
        Comparators.registerComparator(EntityData.class, ItemType.class, entityItemComparator);
        Comparators.registerComparator(CommandSender.class, CommandSender.class, new Comparator<CommandSender, CommandSender>(){

            @Override
            public Comparator.Relation compare(CommandSender s1, CommandSender s2) {
                return Comparator.Relation.get(s1.equals(s2));
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        Comparators.registerComparator(OfflinePlayer.class, OfflinePlayer.class, new Comparator<OfflinePlayer, OfflinePlayer>(){

            @Override
            public Comparator.Relation compare(OfflinePlayer p1, OfflinePlayer p2) {
                return Comparator.Relation.get(Objects.equals(p1.getName(), p2.getName()));
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        Comparators.registerComparator(OfflinePlayer.class, String.class, new Comparator<OfflinePlayer, String>(){

            @Override
            public Comparator.Relation compare(OfflinePlayer p, String name) {
                String offlineName = p.getName();
                return offlineName == null ? Comparator.Relation.NOT_EQUAL : Comparator.Relation.get(offlineName.equalsIgnoreCase(name));
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        Comparators.registerComparator(World.class, String.class, new Comparator<World, String>(){

            @Override
            public Comparator.Relation compare(World w, String name) {
                return Comparator.Relation.get(w.getName().equalsIgnoreCase(name));
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        Comparators.registerComparator(String.class, String.class, new Comparator<String, String>(){

            @Override
            public Comparator.Relation compare(String s1, String s2) {
                return Comparator.Relation.get(StringUtils.equals(s1, s2, SkriptConfig.caseSensitive.value()));
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        Comparators.registerComparator(Date.class, Date.class, new Comparator<Date, Date>(){

            @Override
            public Comparator.Relation compare(Date d1, Date d2) {
                return Comparator.Relation.get(d1.compareTo(d2));
            }

            @Override
            public boolean supportsOrdering() {
                return true;
            }
        });
        Comparators.registerComparator(Time.class, Time.class, new Comparator<Time, Time>(){

            @Override
            public Comparator.Relation compare(Time t1, Time t2) {
                return Comparator.Relation.get(t1.getTime() - t2.getTime());
            }

            @Override
            public boolean supportsOrdering() {
                return true;
            }
        });
        Comparators.registerComparator(Timespan.class, Timespan.class, new Comparator<Timespan, Timespan>(){

            @Override
            public Comparator.Relation compare(Timespan t1, Timespan t2) {
                return Comparator.Relation.get(t1.getMilliSeconds() - t2.getMilliSeconds());
            }

            @Override
            public boolean supportsOrdering() {
                return true;
            }
        });
        Comparators.registerComparator(Time.class, Timeperiod.class, new Comparator<Time, Timeperiod>(){

            @Override
            public Comparator.Relation compare(Time t, Timeperiod p) {
                return Comparator.Relation.get(p.contains(t));
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        Comparators.registerComparator(StructureType.class, StructureType.class, new Comparator<StructureType, StructureType>(){

            @Override
            public Comparator.Relation compare(StructureType s1, StructureType s2) {
                return Comparator.Relation.get(CollectionUtils.containsAll(s2.getTypes(), s2.getTypes()));
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        Comparators.registerComparator(Object.class, ClassInfo.class, new Comparator<Object, ClassInfo>(){

            @Override
            public Comparator.Relation compare(Object o, ClassInfo c) {
                return Comparator.Relation.get(c.getC().isInstance(o) || o instanceof ClassInfo && c.getC().isAssignableFrom(((ClassInfo)o).getC()));
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        Comparators.registerComparator(EntityDamageEvent.DamageCause.class, ItemType.class, new Comparator<EntityDamageEvent.DamageCause, ItemType>(){

            @Override
            public Comparator.Relation compare(EntityDamageEvent.DamageCause dc, ItemType t) {
                switch (dc) {
                    case FIRE: {
                        return Comparator.Relation.get(t.isOfType(Material.FIRE.getId(), (short)-1));
                    }
                    case LAVA: {
                        return Comparator.Relation.get(t.isOfType(Material.LAVA.getId(), (short)-1) && t.isOfType(Material.STATIONARY_LAVA.getId(), (short)-1));
                    }
                    case MAGIC: {
                        return Comparator.Relation.get(t.isOfType(Material.POTION.getId(), (short)-1));
                    }
                }
                return Comparator.Relation.NOT_EQUAL;
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        Comparators.registerComparator(EntityDamageEvent.DamageCause.class, EntityData.class, new Comparator<EntityDamageEvent.DamageCause, EntityData>(){

            @Override
            public Comparator.Relation compare(EntityDamageEvent.DamageCause dc, EntityData e) {
                switch (dc) {
                    case ENTITY_ATTACK: {
                        return Comparator.Relation.get(e.isSupertypeOf(EntityData.fromClass(Entity.class)));
                    }
                    case PROJECTILE: {
                        return Comparator.Relation.get(e.isSupertypeOf(EntityData.fromClass(Projectile.class)));
                    }
                    case WITHER: {
                        return Comparator.Relation.get(e.isSupertypeOf(EntityData.fromClass(Wither.class)));
                    }
                    case FALLING_BLOCK: {
                        return Comparator.Relation.get(e.isSupertypeOf(EntityData.fromClass(FallingBlock.class)));
                    }
                }
                return Comparator.Relation.NOT_EQUAL;
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
    }
}

