/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.util.Slot;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

@Name(value="Is Empty")
@Description(value={"Checks whether an inventory, an inventory slot, or a text is empty."})
@Examples(value={"player's inventory is empty"})
@Since(value="<i>unknown</i> (before 2.1)")
public class CondIsEmpty
extends PropertyCondition<Object> {
    static {
        CondIsEmpty.register(CondIsEmpty.class, "empty", "inventories/slots/strings");
    }

    @Override
    public boolean check(Object o) {
        if (o instanceof String) {
            return ((String)o).isEmpty();
        }
        if (o instanceof Inventory) {
            ItemStack[] itemStackArray = ((Inventory)o).getContents();
            int n = itemStackArray.length;
            int n2 = 0;
            while (n2 < n) {
                ItemStack s = itemStackArray[n2];
                if (s != null && s.getType() != Material.AIR) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        if (o instanceof Slot) {
            Slot s = (Slot)o;
            ItemStack i = s.getItem();
            return i == null || i.getType() == Material.AIR;
        }
        return false;
    }

    @Override
    protected String getPropertyName() {
        return "empty";
    }
}

