/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.command;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.command.Argument;
import ch.njol.skript.command.EffectCommandEvent;
import ch.njol.skript.command.ScriptCommand;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.config.validate.SectionValidator;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.localization.ArgsMessage;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.Message;
import ch.njol.skript.log.RetainingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Utils;
import ch.njol.util.Callback;
import ch.njol.util.NonNullPair;
import ch.njol.util.StringUtils;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.help.HelpMap;
import org.bukkit.help.HelpTopic;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.SimplePluginManager;
import org.eclipse.jdt.annotation.Nullable;

public abstract class Commands {
    public static final ArgsMessage m_too_many_arguments = new ArgsMessage("commands.too many arguments");
    public static final Message m_correct_usage = new Message("commands.correct usage");
    public static final Message m_internal_error = new Message("commands.internal error");
    private static final Map<String, ScriptCommand> commands = new HashMap<String, ScriptCommand>();
    @Nullable
    private static SimpleCommandMap commandMap = null;
    @Nullable
    private static Map<String, Command> cmKnownCommands;
    @Nullable
    private static Set<String> cmAliases;
    private static final SectionValidator commandStructure;
    @Nullable
    public static List<Argument<?>> currentArguments;
    private static final Pattern escape;
    private static final Pattern unescape;
    private static final Listener commandListener;
    @Nullable
    private static final Listener pre1_3chatListener;
    @Nullable
    private static final Listener post1_3chatListener;
    private static final Pattern commandPattern;
    private static final Pattern argumentPattern;
    private static boolean registeredListeners;

    static {
        Commands.init();
        commandStructure = new SectionValidator().addEntry("usage", true).addEntry("description", true).addEntry("permission", true).addEntry("permission message", true).addEntry("aliases", true).addEntry("executable by", true).addSection("trigger", false);
        currentArguments = null;
        escape = Pattern.compile("[" + Pattern.quote("(|)<>%\\") + "]");
        unescape = Pattern.compile("\\\\[" + Pattern.quote("(|)<>%\\") + "]");
        commandListener = new Listener(){

            @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
            public void onPlayerCommand(PlayerCommandPreprocessEvent e) {
                if (Commands.handleCommand((CommandSender)e.getPlayer(), e.getMessage().substring(1))) {
                    e.setCancelled(true);
                }
            }

            @EventHandler(priority=EventPriority.HIGHEST)
            public void onServerCommand(ServerCommandEvent e) {
                if (e.getCommand() == null || e.getCommand().isEmpty()) {
                    return;
                }
                if (SkriptConfig.enableEffectCommands.value().booleanValue() && e.getCommand().startsWith(SkriptConfig.effectCommandToken.value())) {
                    if (Commands.handleEffectCommand(e.getSender(), e.getCommand())) {
                        e.setCancelled(true);
                    }
                    return;
                }
            }
        };
        pre1_3chatListener = Skript.classExists("org.bukkit.event.player.AsyncPlayerChatEvent") ? null : new Listener(){

            @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
            public void onPlayerChat(PlayerChatEvent e) {
                if (!SkriptConfig.enableEffectCommands.value().booleanValue() || !e.getMessage().startsWith(SkriptConfig.effectCommandToken.value())) {
                    return;
                }
                if (Commands.handleEffectCommand((CommandSender)e.getPlayer(), e.getMessage())) {
                    e.setCancelled(true);
                }
            }
        };
        post1_3chatListener = !Skript.classExists("org.bukkit.event.player.AsyncPlayerChatEvent") ? null : new Listener(){

            @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
            public void onPlayerChat(final AsyncPlayerChatEvent e) {
                if (!SkriptConfig.enableEffectCommands.value().booleanValue() || !e.getMessage().startsWith(SkriptConfig.effectCommandToken.value())) {
                    return;
                }
                if (!e.isAsynchronous()) {
                    if (Commands.handleEffectCommand((CommandSender)e.getPlayer(), e.getMessage())) {
                        e.setCancelled(true);
                    }
                } else {
                    Future f = Bukkit.getScheduler().callSyncMethod((Plugin)Skript.getInstance(), (Callable)new Callable<Boolean>(){

                        @Override
                        public Boolean call() throws Exception {
                            return Commands.handleEffectCommand((CommandSender)e.getPlayer(), e.getMessage());
                        }
                    });
                    try {
                        while (true) {
                            try {
                                if (((Boolean)f.get()).booleanValue()) {
                                    e.setCancelled(true);
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (ExecutionException e1) {
                        Skript.exception((Throwable)e1, new String[0]);
                    }
                }
            }
        };
        commandPattern = Pattern.compile("(?i)^command /?(\\S+)(\\s+(.+))?$");
        argumentPattern = Pattern.compile("<\\s*(?:(.+?)\\s*:\\s*)?(.+?)\\s*(?:=\\s*([^\"]*?(?:\"[^\"]*?\"[^\"]*?)*?))?\\s*>");
        registeredListeners = false;
    }

    private static final void init() {
        try {
            if (Bukkit.getPluginManager() instanceof SimplePluginManager) {
                Field commandMapField = SimplePluginManager.class.getDeclaredField("commandMap");
                commandMapField.setAccessible(true);
                commandMap = (SimpleCommandMap)commandMapField.get(Bukkit.getPluginManager());
                Field knownCommandsField = SimpleCommandMap.class.getDeclaredField("knownCommands");
                knownCommandsField.setAccessible(true);
                cmKnownCommands = (Map)knownCommandsField.get(commandMap);
                try {
                    Field aliasesField = SimpleCommandMap.class.getDeclaredField("aliases");
                    aliasesField.setAccessible(true);
                    cmAliases = (Set)aliasesField.get(commandMap);
                }
                catch (NoSuchFieldException noSuchFieldException) {}
            }
        }
        catch (SecurityException e) {
            Skript.error("Please disable the security manager");
            commandMap = null;
        }
        catch (Exception e) {
            Skript.outdatedError(e);
            commandMap = null;
        }
    }

    private static final String escape(String s) {
        return escape.matcher(s).replaceAll("\\\\$0");
    }

    private static final String unescape(String s) {
        return unescape.matcher(s).replaceAll("$0");
    }

    static final boolean handleCommand(CommandSender sender, String command) {
        ScriptCommand c;
        String[] cmd = command.split("\\s+", 2);
        cmd[0] = cmd[0].toLowerCase();
        if (cmd[0].endsWith("?") && (c = commands.get(cmd[0].substring(0, cmd[0].length() - 1))) != null) {
            c.sendHelp(sender);
            return true;
        }
        c = commands.get(cmd[0]);
        if (c != null) {
            if (SkriptConfig.logPlayerCommands.value().booleanValue() && sender instanceof Player) {
                SkriptLogger.LOGGER.info(String.valueOf(sender.getName()) + " [" + ((Player)sender).getUniqueId() + "]: /" + command);
            }
            c.execute(sender, cmd[0], cmd.length == 1 ? "" : cmd[1]);
            return true;
        }
        return false;
    }

    static final boolean handleEffectCommand(CommandSender sender, String command) {
        if (!(sender instanceof ConsoleCommandSender || sender.hasPermission("skript.effectcommands") || SkriptConfig.allowOpsToUseEffectCommands.value().booleanValue() && sender.isOp())) {
            return false;
        }
        boolean wasLocal = Language.setUseLocal(false);
        try {
            command = command.substring(SkriptConfig.effectCommandToken.value().length()).trim();
            RetainingLogHandler log = SkriptLogger.startRetainingLog();
            try {
                ScriptLoader.setCurrentEvent("effect command", EffectCommandEvent.class);
                Effect e = Effect.parse(command, null);
                ScriptLoader.deleteCurrentEvent();
                if (e != null) {
                    log.clear();
                    log.printLog();
                    sender.sendMessage(ChatColor.GRAY + "executing '" + ChatColor.stripColor((String)command) + "'");
                    if (SkriptConfig.logPlayerCommands.value().booleanValue() && !(sender instanceof ConsoleCommandSender)) {
                        Skript.info(String.valueOf(sender.getName()) + " issued effect command: " + command);
                    }
                    e.run(new EffectCommandEvent(sender, command));
                } else {
                    if (sender == Bukkit.getConsoleSender()) {
                        SkriptLogger.LOGGER.severe("Error in: " + ChatColor.stripColor((String)command));
                    } else {
                        sender.sendMessage(ChatColor.RED + "Error in: " + ChatColor.GRAY + ChatColor.stripColor((String)command));
                    }
                    log.printErrors(sender, "(No specific information is available)");
                }
            }
            finally {
                log.stop();
            }
            return true;
        }
        catch (Exception e) {
            Skript.exception((Throwable)e, "Unexpected error while executing effect command '" + command + "' by '" + sender.getName() + "'");
            sender.sendMessage(ChatColor.RED + "An internal error occurred while executing this effect. Please refer to the server log for details.");
            return true;
        }
        finally {
            Language.setUseLocal(wasLocal);
        }
    }

    @Nullable
    public static final ScriptCommand loadCommand(SectionNode node) {
        return Commands.loadCommand(node, true);
    }

    @Nullable
    public static final ScriptCommand loadCommand(SectionNode node, boolean alsoRegister) {
        ScriptCommand c;
        File config;
        String key = node.getKey();
        if (key == null) {
            return null;
        }
        String s = ScriptLoader.replaceOptions(key);
        int level = 0;
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == '[') {
                ++level;
            } else if (s.charAt(i) == ']') {
                if (level == 0) {
                    Skript.error("Invalid placement of [optional brackets]");
                    return null;
                }
                --level;
            }
            ++i;
        }
        if (level > 0) {
            Skript.error("Invalid amount of [optional brackets]");
            return null;
        }
        Matcher m = commandPattern.matcher(s);
        boolean a = m.matches();
        assert (a);
        String command = m.group(1).toLowerCase();
        ScriptCommand existingCommand = commands.get(command);
        if (alsoRegister && existingCommand != null && existingCommand.getLabel().equals(command)) {
            File f = existingCommand.getScript();
            Skript.error("A command with the name /" + existingCommand.getName() + " is already defined" + (f == null ? "" : " in " + f.getName()));
            return null;
        }
        String arguments = m.group(3) == null ? "" : m.group(3);
        StringBuilder pattern = new StringBuilder();
        currentArguments = new ArrayList();
        ArrayList currentArguments = Commands.currentArguments;
        m = argumentPattern.matcher(arguments);
        int lastEnd = 0;
        int optionals = 0;
        int i2 = 0;
        while (m.find()) {
            pattern.append(Commands.escape(arguments.substring(lastEnd, m.start())));
            optionals += StringUtils.count(arguments, '[', lastEnd, m.start());
            optionals -= StringUtils.count(arguments, ']', lastEnd, m.start());
            lastEnd = m.end();
            ClassInfo<?> c2 = Classes.getClassInfoFromUserInput(m.group(2));
            NonNullPair<String, Boolean> p = Utils.getEnglishPlural(m.group(2));
            if (c2 == null) {
                c2 = Classes.getClassInfoFromUserInput(p.getFirst());
            }
            if (c2 == null) {
                Skript.error("Unknown type '" + m.group(2) + "'");
                return null;
            }
            Parser<?> parser = c2.getParser();
            if (parser == null || !parser.canParse(ParseContext.COMMAND)) {
                Skript.error("Can't use " + c2 + " as argument of a command");
                return null;
            }
            Argument<?> arg = Argument.newInstance(m.group(1), c2, m.group(3), i2, p.getSecond() == false, optionals > 0);
            if (arg == null) {
                return null;
            }
            currentArguments.add(arg);
            if (arg.isOptional() && optionals == 0) {
                pattern.append('[');
                ++optionals;
            }
            pattern.append("%" + (arg.isOptional() ? "-" : "") + Utils.toEnglishPlural(c2.getCodeName(), p.getSecond()) + "%");
            ++i2;
        }
        pattern.append(Commands.escape(arguments.substring(lastEnd)));
        optionals += StringUtils.count(arguments, '[', lastEnd);
        optionals -= StringUtils.count(arguments, ']', lastEnd);
        i2 = 0;
        while (i2 < optionals) {
            pattern.append(']');
            ++i2;
        }
        String desc = "/" + command + " ";
        boolean wasLocal = Language.setUseLocal(true);
        try {
            desc = String.valueOf(desc) + StringUtils.replaceAll((CharSequence)pattern, "(?<!\\\\)%-?(.+?)%", new Callback<String, Matcher>(){

                @Override
                public String run(@Nullable Matcher m) {
                    if (!$assertionsDisabled && m == null) {
                        throw new AssertionError();
                    }
                    NonNullPair<String, Boolean> p = Utils.getEnglishPlural(m.group(1));
                    String s = p.getFirst();
                    return "<" + Classes.getClassInfo(s).getName().toString(p.getSecond()) + ">";
                }
            });
        }
        finally {
            Language.setUseLocal(wasLocal);
        }
        desc = Commands.unescape(desc);
        desc = desc.trim();
        node.convertToEntries(0);
        commandStructure.validate(node);
        if (!(node.get("trigger") instanceof SectionNode)) {
            return null;
        }
        String usage = ScriptLoader.replaceOptions(node.get("usage", desc));
        String description = ScriptLoader.replaceOptions(node.get("description", ""));
        ArrayList<String> aliases = new ArrayList<String>(Arrays.asList(ScriptLoader.replaceOptions(node.get("aliases", "")).split("\\s*,\\s*/?")));
        if (aliases.get(0).startsWith("/")) {
            aliases.set(0, aliases.get(0).substring(1));
        } else if (aliases.get(0).isEmpty()) {
            aliases = new ArrayList(0);
        }
        String permission = ScriptLoader.replaceOptions(node.get("permission", ""));
        String permissionMessage = ScriptLoader.replaceOptions(node.get("permission message", ""));
        SectionNode trigger = (SectionNode)node.get("trigger");
        if (trigger == null) {
            return null;
        }
        String[] by = ScriptLoader.replaceOptions(node.get("executable by", "console,players")).split("\\s*,\\s*|\\s+(and|or)\\s+");
        int executableBy = 0;
        String[] stringArray = by;
        int n = by.length;
        int n2 = 0;
        while (n2 < n) {
            String b = stringArray[n2];
            if (b.equalsIgnoreCase("console") || b.equalsIgnoreCase("the console")) {
                executableBy |= 2;
            } else if (b.equalsIgnoreCase("players") || b.equalsIgnoreCase("player")) {
                executableBy |= 1;
            } else {
                Skript.warning("'executable by' should be either be 'players', 'console', or both, but found '" + b + "'");
            }
            ++n2;
        }
        if (!permissionMessage.isEmpty() && permission.isEmpty()) {
            Skript.warning("command /" + command + " has a permission message set, but not a permission");
        }
        if (Skript.debug() || node.debug()) {
            Skript.debug("command " + desc + ":");
        }
        if ((config = node.getConfig().getFile()) == null) {
            assert (false);
            return null;
        }
        Commands.currentArguments = currentArguments;
        try {
            c = new ScriptCommand(config, command, pattern.toString(), currentArguments, description, usage, aliases, permission, permissionMessage, executableBy, ScriptLoader.loadItems(trigger));
        }
        finally {
            Commands.currentArguments = null;
        }
        if (alsoRegister) {
            Commands.registerCommand(c);
        }
        if (Skript.logVeryHigh() && !Skript.debug()) {
            Skript.info("registered command " + desc);
        }
        currentArguments = null;
        return c;
    }

    public static void registerCommand(ScriptCommand command) {
        ScriptCommand existingCommand = commands.get(command.getLabel());
        if (existingCommand != null && existingCommand.getLabel().equals(command.getLabel())) {
            File f = existingCommand.getScript();
            Skript.error("A command with the name /" + existingCommand.getName() + " is already defined" + (f == null ? "" : " in " + f.getName()));
            return;
        }
        if (commandMap != null) {
            assert (cmKnownCommands != null);
            command.register(commandMap, cmKnownCommands, cmAliases);
        }
        commands.put(command.getLabel(), command);
        for (String alias : command.getActiveAliases()) {
            commands.put(alias.toLowerCase(), command);
        }
        command.registerHelp();
    }

    public static int unregisterCommands(File script) {
        int numCommands = 0;
        Iterator<ScriptCommand> commandsIter = commands.values().iterator();
        while (commandsIter.hasNext()) {
            ScriptCommand c = commandsIter.next();
            if (!script.equals(c.getScript())) continue;
            ++numCommands;
            c.unregisterHelp();
            if (commandMap != null) {
                assert (cmKnownCommands != null);
                c.unregister(commandMap, cmKnownCommands, cmAliases);
            }
            commandsIter.remove();
        }
        return numCommands;
    }

    public static final void registerListeners() {
        if (!registeredListeners) {
            Bukkit.getPluginManager().registerEvents(commandListener, (Plugin)Skript.getInstance());
            Bukkit.getPluginManager().registerEvents(post1_3chatListener != null ? post1_3chatListener : pre1_3chatListener, (Plugin)Skript.getInstance());
            registeredListeners = true;
        }
    }

    public static final void clearCommands() {
        SimpleCommandMap commandMap = Commands.commandMap;
        if (commandMap != null) {
            Map<String, Command> cmKnownCommands = Commands.cmKnownCommands;
            Set<String> cmAliases = Commands.cmAliases;
            assert (cmKnownCommands != null);
            for (ScriptCommand c : commands.values()) {
                c.unregister(commandMap, cmKnownCommands, cmAliases);
            }
        }
        for (ScriptCommand c : commands.values()) {
            c.unregisterHelp();
        }
        commands.clear();
    }

    public static final class CommandAliasHelpTopic
    extends HelpTopic {
        private final String aliasFor;
        private final HelpMap helpMap;

        public CommandAliasHelpTopic(String alias, String aliasFor, HelpMap helpMap) {
            this.aliasFor = aliasFor.startsWith("/") ? aliasFor : "/" + aliasFor;
            this.helpMap = helpMap;
            this.name = alias.startsWith("/") ? alias : "/" + alias;
            Validate.isTrue((!this.name.equals(this.aliasFor) ? 1 : 0) != 0, (String)("Command " + this.name + " cannot be alias for itself"));
            this.shortText = ChatColor.YELLOW + "Alias for " + ChatColor.WHITE + this.aliasFor;
        }

        public String getFullText(@Nullable CommandSender forWho) {
            StringBuilder sb = new StringBuilder(this.shortText);
            HelpTopic aliasForTopic = this.helpMap.getHelpTopic(this.aliasFor);
            if (aliasForTopic != null) {
                sb.append("\n");
                sb.append(aliasForTopic.getFullText(forWho));
            }
            return sb.toString();
        }

        public boolean canSee(@Nullable CommandSender commandSender) {
            if (this.amendedPermission == null) {
                HelpTopic aliasForTopic = this.helpMap.getHelpTopic(this.aliasFor);
                if (aliasForTopic != null) {
                    return aliasForTopic.canSee(commandSender);
                }
                return false;
            }
            return commandSender != null && commandSender.hasPermission(this.amendedPermission);
        }
    }
}

