/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Vectors - Angle between")
@Description(value={"Gets the angle between two vectors"})
@Examples(value={"send \"%angle between vector 1, 0, 0 and vector 0, 1, 1%\""})
@Since(value="2.2-dev28")
public class ExprVectorAngleBetween
extends SimpleExpression<Float> {
    private Expression<Vector> first;
    private Expression<Vector> second;

    static {
        Skript.registerExpression(ExprVectorAngleBetween.class, Float.class, ExpressionType.SIMPLE, "angle between %vector% and %vector%");
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public String toString(@Nullable Event event, boolean b) {
        return "angle between " + this.first.toString() + " and " + this.second.toString();
    }

    @Override
    public Class<? extends Float> getReturnType() {
        return Float.class;
    }

    @Override
    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.first = expressions[0];
        this.second = expressions[1];
        return true;
    }

    protected Float[] get(Event event) {
        Vector v1 = this.first.getSingle(event);
        Vector v2 = this.second.getSingle(event);
        if (v1 == null || v2 == null) {
            return null;
        }
        return new Float[]{Float.valueOf(v1.angle(v2) * 57.29578f)};
    }
}

