/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Formatted time")
@Description(value={"Converts date to human-readable text format. By default, yyyy-MM-dd HH:mm:ss z will be used. For reference, see this <a href=\"https://en.wikipedia.org/wiki/ISO_8601\">Wikipedia article</a>."})
@Examples(value={"now formatted human-readable"})
@Since(value="2.2-dev31")
public class ExprFormatTime
extends SimpleExpression<String> {
    private static final String defaultFormat = "yyyy-MM-dd HH:mm:ss z";
    private Expression<ch.njol.skript.util.Date> date;
    private SimpleDateFormat format;

    static {
        Skript.registerExpression(ExprFormatTime.class, String.class, ExpressionType.PROPERTY, "%date% formatted human-readable [with %-string%]");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.date = exprs[0];
        if (exprs[1] != null) {
            VariableString str;
            if (!(exprs[1] instanceof Literal) && !(str = (VariableString)exprs[1]).isSimple()) {
                Skript.error("Date format must not contain variables!");
                return false;
            }
            this.format = new SimpleDateFormat((String)exprs[1].getSingle(null));
        } else {
            this.format = new SimpleDateFormat(defaultFormat);
        }
        return true;
    }

    @Nullable
    protected String[] get(Event e) {
        ch.njol.skript.util.Date d = this.date.getSingle(e);
        if (d == null) {
            return null;
        }
        return new String[]{this.format.format(new Date(d.getTimestamp()))};
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "formatted time";
    }
}

