/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Getter;
import ch.njol.util.Kleenean;
import ch.njol.util.Math2;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Food Level")
@Description(value={"The food level of a player from 0 to 10. Has several aliases: food/hunger level/meter/bar. "})
@Examples(value={"set the player's food level to 10"})
@Since(value="1.0")
public class ExprFoodLevel
extends PropertyExpression<Player, Float> {
    static {
        Skript.registerExpression(ExprFoodLevel.class, Float.class, ExpressionType.PROPERTY, "[the] (food|hunger)[[ ](level|met(er|re)|bar)] [of %player%]", "%player%'[s] (food|hunger)[[ ](level|met(er|re)|bar)]", "feed [the] %player%");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.setExpr(vars[0]);
        return true;
    }

    protected Float[] get(final Event e, Player[] source) {
        return this.get(source, new Getter<Float, Player>(){

            @Override
            public Float get(Player p) {
                if (ExprFoodLevel.this.getTime() >= 0 && e instanceof FoodLevelChangeEvent && p.equals(((FoodLevelChangeEvent)e).getEntity()) && !Delay.isDelayed(e)) {
                    return Float.valueOf(0.5f * (float)((FoodLevelChangeEvent)e).getFoodLevel());
                }
                return Float.valueOf(0.5f * (float)p.getFoodLevel());
            }
        });
    }

    @Override
    public Class<Float> getReturnType() {
        return Float.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "the food level of " + this.getExpr().toString(e, debug);
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.REMOVE_ALL) {
            return null;
        }
        return CollectionUtils.array(Number.class);
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        assert (mode != Changer.ChangeMode.REMOVE_ALL);
        int s = delta == null ? 0 : Math.round(((Number)delta[0]).floatValue() * 2.0f);
        Player[] playerArray = (Player[])this.getExpr().getArray(e);
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player player = playerArray[n2];
            boolean event = this.getTime() >= 0 && e instanceof FoodLevelChangeEvent && ((FoodLevelChangeEvent)e).getEntity() == player && !Delay.isDelayed(e);
            int food = event ? ((FoodLevelChangeEvent)e).getFoodLevel() : player.getFoodLevel();
            switch (mode) {
                case SET: 
                case DELETE: {
                    food = Math2.fit(0, s, 20);
                    break;
                }
                case ADD: {
                    food = Math2.fit(0, food + s, 20);
                    break;
                }
                case REMOVE: {
                    food = Math2.fit(0, food - s, 20);
                    break;
                }
                case RESET: {
                    food = 20;
                    break;
                }
                case REMOVE_ALL: {
                    assert (false);
                    break;
                }
            }
            if (event) {
                ((FoodLevelChangeEvent)e).setFoodLevel(food);
            } else {
                player.setFoodLevel(food);
            }
            ++n2;
        }
    }

    @Override
    public boolean setTime(int time) {
        return super.setTime(time, FoodLevelChangeEvent.class, this.getExpr());
    }
}

