/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Toggle")
@Description(value={"Toggle the state of a block."})
@Examples(value={"# use arrows to toggle switches, doors, etc.", "on projectile hit:", "    projectile is arrow", "    toggle the block at the arrow"})
@Since(value="1.4")
public class EffToggle
extends Effect {
    private Expression<Block> blocks;
    private int toggle;
    private static final byte[] bitFlags;
    private static final boolean[] doors;

    static {
        Skript.registerEffect(EffToggle.class, "(close|turn off|de[-]activate) %blocks%", "(toggle|switch) [[the] state of] %blocks%", "(open|turn on|activate) %blocks%");
        bitFlags = new byte[256];
        doors = new boolean[256];
        EffToggle.bitFlags[Material.DETECTOR_RAIL.getId()] = 8;
        EffToggle.bitFlags[Material.WOODEN_DOOR.getId()] = 4;
        EffToggle.bitFlags[Material.SPRUCE_DOOR.getId()] = 4;
        EffToggle.bitFlags[Material.BIRCH_DOOR.getId()] = 4;
        EffToggle.bitFlags[Material.JUNGLE_DOOR.getId()] = 4;
        EffToggle.bitFlags[Material.ACACIA_DOOR.getId()] = 4;
        EffToggle.bitFlags[Material.DARK_OAK_DOOR.getId()] = 4;
        EffToggle.bitFlags[Material.IRON_DOOR_BLOCK.getId()] = 4;
        EffToggle.bitFlags[Material.LEVER.getId()] = 8;
        EffToggle.bitFlags[Material.STONE_PLATE.getId()] = 1;
        EffToggle.bitFlags[Material.WOOD_PLATE.getId()] = 1;
        EffToggle.bitFlags[Material.STONE_BUTTON.getId()] = 8;
        EffToggle.bitFlags[Material.TRAP_DOOR.getId()] = 4;
        EffToggle.bitFlags[Material.IRON_TRAPDOOR.getId()] = 4;
        EffToggle.bitFlags[Material.FENCE_GATE.getId()] = 4;
        EffToggle.bitFlags[Material.SPRUCE_FENCE_GATE.getId()] = 4;
        EffToggle.bitFlags[Material.BIRCH_FENCE_GATE.getId()] = 4;
        EffToggle.bitFlags[Material.JUNGLE_FENCE_GATE.getId()] = 4;
        EffToggle.bitFlags[Material.DARK_OAK_FENCE_GATE.getId()] = 4;
        EffToggle.bitFlags[Material.ACACIA_FENCE_GATE.getId()] = 4;
        EffToggle.doors[Material.WOODEN_DOOR.getId()] = true;
        EffToggle.doors[Material.SPRUCE_DOOR.getId()] = true;
        EffToggle.doors[Material.BIRCH_DOOR.getId()] = true;
        EffToggle.doors[Material.JUNGLE_DOOR.getId()] = true;
        EffToggle.doors[Material.ACACIA_DOOR.getId()] = true;
        EffToggle.doors[Material.DARK_OAK_DOOR.getId()] = true;
        EffToggle.doors[Material.IRON_DOOR_BLOCK.getId()] = true;
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.blocks = vars[0];
        this.toggle = matchedPattern - 1;
        return true;
    }

    @Override
    protected void execute(Event e) {
        Block[] blockArray = this.blocks.getArray(e);
        int n = blockArray.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                byte data;
                int type;
                Block b;
                block8: {
                    b = blockArray[n2];
                    type = b.getTypeId();
                    data = b.getData();
                    if (!doors[type] || (data & 8) != 8) break block8;
                    type = (b = b.getRelative(BlockFace.DOWN)).getTypeId();
                    if (!doors[type]) break block9;
                    data = b.getData();
                }
                if (this.toggle == -1) {
                    b.setData((byte)(data & ~bitFlags[type]));
                } else if (this.toggle == 0) {
                    b.setData((byte)(data ^ bitFlags[type]));
                } else {
                    b.setData((byte)(data | bitFlags[type]));
                }
            }
            ++n2;
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "toggle " + this.blocks.toString(e, debug);
    }
}

