/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.Updater;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.command.CommandHelp;
import ch.njol.skript.config.Config;
import ch.njol.skript.doc.HTMLGenerator;
import ch.njol.skript.localization.ArgsMessage;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.PluralizingArgsMessage;
import ch.njol.skript.log.RedirectingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.util.Color;
import ch.njol.skript.util.ExceptionUtils;
import ch.njol.skript.util.FileUtils;
import ch.njol.util.StringUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.eclipse.jdt.annotation.Nullable;

public class SkriptCommand
implements CommandExecutor {
    private static final String NODE = "skript command";
    private static final CommandHelp skriptCommandHelp = new CommandHelp("<gray>/<gold>skript", Color.LIGHT_CYAN, "skript command.help").add(new CommandHelp("reload", Color.DARK_RED).add("all").add("config").add("aliases").add("scripts").add("<script>")).add(new CommandHelp("enable", Color.DARK_RED).add("all").add("<script>")).add(new CommandHelp("disable", Color.DARK_RED).add("all").add("<script>")).add(new CommandHelp("update", Color.DARK_RED).add("check").add("changes").add("download")).add(new CommandHelp("timings", Color.DARK_RED).add("start").add("stop")).add("help");
    private static final ArgsMessage m_reloading;
    private static final ArgsMessage m_reloaded;
    private static final ArgsMessage m_reload_error;
    private static final ArgsMessage m_changes_title;
    private static final ArgsMessage m_invalid_script;
    private static final ArgsMessage m_invalid_folder;

    static {
        if (new File(Skript.getInstance().getDataFolder() + "/doc-templates").exists()) {
            skriptCommandHelp.add("gen-docs");
        }
        m_reloading = new ArgsMessage("skript command.reload.reloading");
        m_reloaded = new ArgsMessage("skript command.reload.reloaded");
        m_reload_error = new ArgsMessage("skript command.reload.error");
        m_changes_title = new ArgsMessage("skript command.update.changes.title");
        m_invalid_script = new ArgsMessage("skript command.invalid script");
        m_invalid_folder = new ArgsMessage("skript command.invalid folder");
    }

    private static final void reloading(CommandSender sender, String what, Object ... args) {
        what = args.length == 0 ? Language.get("skript command.reload." + what) : Language.format("skript command.reload." + what, args);
        Skript.info(sender, StringUtils.fixCapitalization(m_reloading.toString(what)));
    }

    private static final void reloaded(CommandSender sender, RedirectingLogHandler r, String what, Object ... args) {
        String string = what = args.length == 0 ? Language.get("skript command.reload." + what) : PluralizingArgsMessage.format(Language.format("skript command.reload." + what, args));
        if (r.numErrors() == 0) {
            Skript.info(sender, StringUtils.fixCapitalization(PluralizingArgsMessage.format(m_reloaded.toString(what))));
        } else {
            Skript.error(sender, StringUtils.fixCapitalization(PluralizingArgsMessage.format(m_reload_error.toString(what, r.numErrors()))));
        }
    }

    private static final void info(CommandSender sender, String what, Object ... args) {
        what = args.length == 0 ? Language.get("skript command." + what) : PluralizingArgsMessage.format(Language.format("skript command." + what, args));
        Skript.info(sender, StringUtils.fixCapitalization(what));
    }

    private static final void message(CommandSender sender, String what, Object ... args) {
        what = args.length == 0 ? Language.get("skript command." + what) : PluralizingArgsMessage.format(Language.format("skript command." + what, args));
        Skript.message(sender, StringUtils.fixCapitalization(what));
    }

    private static final void error(CommandSender sender, String what, Object ... args) {
        what = args.length == 0 ? Language.get("skript command." + what) : PluralizingArgsMessage.format(Language.format("skript command." + what, args));
        Skript.error(sender, StringUtils.fixCapitalization(what));
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"})
    public boolean onCommand(@Nullable CommandSender sender, @Nullable Command command, @Nullable String label, @Nullable String[] args) {
        block90: {
            if (sender == null || command == null || label == null || args == null) {
                throw new IllegalArgumentException();
            }
            if (!skriptCommandHelp.test(sender, args)) {
                return true;
            }
            RedirectingLogHandler r = SkriptLogger.startLogHandler(new RedirectingLogHandler(sender, ""));
            try {
                File f;
                if (args[0].equalsIgnoreCase("reload")) {
                    if (args[1].equalsIgnoreCase("all")) {
                        SkriptCommand.reloading(sender, "config and scripts", new Object[0]);
                        Skript.reload();
                        SkriptCommand.reloaded(sender, r, "config and scripts", new Object[0]);
                    } else if (args[1].equalsIgnoreCase("scripts")) {
                        SkriptCommand.reloading(sender, "scripts", new Object[0]);
                        Skript.reloadScripts();
                        SkriptCommand.reloaded(sender, r, "scripts", new Object[0]);
                    } else if (args[1].equalsIgnoreCase("config")) {
                        SkriptCommand.reloading(sender, "main config", new Object[0]);
                        Skript.reloadMainConfig();
                        SkriptCommand.reloaded(sender, r, "main config", new Object[0]);
                    } else if (args[1].equalsIgnoreCase("aliases")) {
                        SkriptCommand.reloading(sender, "aliases", new Object[0]);
                        Skript.reloadAliases();
                        SkriptCommand.reloaded(sender, r, "aliases", new Object[0]);
                    } else {
                        f = SkriptCommand.getScriptFromArgs(sender, args, 1);
                        if (f == null) {
                            return true;
                        }
                        if (!f.isDirectory()) {
                            if (f.getName().startsWith("-")) {
                                SkriptCommand.info(sender, "reload.script disabled", f.getName().substring(1));
                                return true;
                            }
                            SkriptCommand.reloading(sender, "script", f.getName());
                            if (!ScriptLoader.loadAsync) {
                                ScriptLoader.unloadScript(f);
                            }
                            Config config = ScriptLoader.loadStructure(f);
                            ScriptLoader.loadScripts(config);
                            SkriptCommand.reloaded(sender, r, "script", f.getName());
                        } else {
                            SkriptCommand.reloading(sender, "scripts in folder", f.getName());
                            if (!ScriptLoader.loadAsync) {
                                ScriptLoader.unloadScripts(f);
                            }
                            List<Config> configs = ScriptLoader.loadStructures(f);
                            int enabled = ScriptLoader.loadScripts(configs).files;
                            if (enabled == 0) {
                                SkriptCommand.info(sender, "reload.empty folder", f.getName());
                            } else {
                                SkriptCommand.reloaded(sender, r, "x scripts in folder", f.getName(), enabled);
                            }
                        }
                    }
                    break block90;
                }
                if (args[0].equalsIgnoreCase("enable")) {
                    Collection<File> scripts;
                    if (args[1].equals("all")) {
                        try {
                            SkriptCommand.info(sender, "enable.all.enabling", new Object[0]);
                            File[] files = SkriptCommand.toggleScripts(new File(Skript.getInstance().getDataFolder(), "scripts"), true).toArray(new File[0]);
                            assert (files != null);
                            List<Config> configs = ScriptLoader.loadStructures(files);
                            ScriptLoader.loadScripts(configs);
                            if (r.numErrors() == 0) {
                                SkriptCommand.info(sender, "enable.all.enabled", new Object[0]);
                                break block90;
                            }
                            SkriptCommand.error(sender, "enable.all.error", r.numErrors());
                        }
                        catch (IOException e) {
                            SkriptCommand.error(sender, "enable.all.io error", ExceptionUtils.toString(e));
                        }
                        break block90;
                    }
                    f = SkriptCommand.getScriptFromArgs(sender, args, 1);
                    if (f == null) {
                        return true;
                    }
                    if (!f.isDirectory()) {
                        if (!f.getName().startsWith("-")) {
                            SkriptCommand.info(sender, "enable.single.already enabled", f.getName(), StringUtils.join(args, " ", 1, args.length));
                            return true;
                        }
                        try {
                            f = FileUtils.move(f, new File(f.getParentFile(), f.getName().substring(1)), false);
                        }
                        catch (IOException e) {
                            SkriptCommand.error(sender, "enable.single.io error", f.getName().substring(1), ExceptionUtils.toString(e));
                            r.stop();
                            return true;
                        }
                        SkriptCommand.info(sender, "enable.single.enabling", f.getName());
                        Config config = ScriptLoader.loadStructure(f);
                        ScriptLoader.loadScripts(config);
                        if (r.numErrors() == 0) {
                            SkriptCommand.info(sender, "enable.single.enabled", f.getName());
                        } else {
                            SkriptCommand.error(sender, "enable.single.error", f.getName(), r.numErrors());
                        }
                        return true;
                    }
                    try {
                        scripts = SkriptCommand.toggleScripts(f, true);
                    }
                    catch (IOException e) {
                        SkriptCommand.error(sender, "enable.folder.io error", f.getName(), ExceptionUtils.toString(e));
                        r.stop();
                        return true;
                    }
                    if (scripts.isEmpty()) {
                        SkriptCommand.info(sender, "enable.folder.empty", f.getName());
                        return true;
                    }
                    SkriptCommand.info(sender, "enable.folder.enabling", f.getName(), scripts.size());
                    File[] ss = scripts.toArray(new File[scripts.size()]);
                    assert (ss != null);
                    List<Config> configs = ScriptLoader.loadStructures(ss);
                    ScriptLoader.ScriptInfo i = ScriptLoader.loadScripts(configs);
                    assert (i.files == scripts.size());
                    if (r.numErrors() == 0) {
                        SkriptCommand.info(sender, "enable.folder.enabled", f.getName(), i.files);
                    } else {
                        SkriptCommand.error(sender, "enable.folder.error", f.getName(), r.numErrors());
                    }
                    return true;
                }
                if (args[0].equalsIgnoreCase("disable")) {
                    Collection<File> scripts;
                    if (args[1].equals("all")) {
                        Skript.disableScripts();
                        try {
                            SkriptCommand.toggleScripts(new File(Skript.getInstance().getDataFolder(), "scripts"), false);
                            SkriptCommand.info(sender, "disable.all.disabled", new Object[0]);
                        }
                        catch (IOException e) {
                            SkriptCommand.error(sender, "disable.all.io error", ExceptionUtils.toString(e));
                        }
                        break block90;
                    }
                    f = SkriptCommand.getScriptFromArgs(sender, args, 1);
                    if (f == null) {
                        return true;
                    }
                    if (!f.isDirectory()) {
                        if (f.getName().startsWith("-")) {
                            SkriptCommand.info(sender, "disable.single.already disabled", f.getName().substring(1));
                            return true;
                        }
                        ScriptLoader.unloadScript(f);
                        try {
                            FileUtils.move(f, new File(f.getParentFile(), "-" + f.getName()), false);
                        }
                        catch (IOException e) {
                            SkriptCommand.error(sender, "disable.single.io error", f.getName(), ExceptionUtils.toString(e));
                            r.stop();
                            return true;
                        }
                        SkriptCommand.info(sender, "disable.single.disabled", f.getName());
                        return true;
                    }
                    try {
                        scripts = SkriptCommand.toggleScripts(f, false);
                    }
                    catch (IOException e) {
                        SkriptCommand.error(sender, "disable.folder.io error", f.getName(), ExceptionUtils.toString(e));
                        r.stop();
                        return true;
                    }
                    if (scripts.isEmpty()) {
                        SkriptCommand.info(sender, "disable.folder.empty", f.getName());
                        return true;
                    }
                    for (File script : scripts) {
                        ScriptLoader.unloadScript(new File(script.getParentFile(), script.getName().substring(1)));
                    }
                    SkriptCommand.info(sender, "disable.folder.disabled", f.getName(), scripts.size());
                    return true;
                }
                if (args[0].equalsIgnoreCase("update")) {
                    Updater.UpdateState state = Updater.state;
                    if (args[1].equals("check")) {
                        Updater.executor.set(sender);
                        switch (state) {
                            case NOT_STARTED: {
                                Updater.start();
                                break;
                            }
                            case CHECKING: {
                                Skript.info(sender, "" + Updater.m_check_in_progress);
                                break;
                            }
                            case RUNNING_LATEST: {
                                Skript.info(sender, "" + Updater.m_running_latest_version);
                                break;
                            }
                            case RUNNING_CUSTOM: {
                                Skript.info(sender, "" + Updater.m_custom_version);
                                break;
                            }
                            case UPDATE_AVAILABLE: {
                                Skript.info(sender, "" + Updater.m_update_available);
                                break;
                            }
                            case DOWNLOADING: {
                                Skript.info(sender, "" + Updater.m_download_in_progress);
                                break;
                            }
                            case DOWNLOADED: {
                                Skript.info(sender, "" + Updater.m_downloaded);
                                break;
                            }
                            case ERROR: {
                                Updater.start();
                            }
                        }
                    } else if (!args[1].equalsIgnoreCase("changes")) {
                        args[1].equalsIgnoreCase("download");
                    }
                    break block90;
                }
                if (args[0].equalsIgnoreCase("help")) {
                    skriptCommandHelp.showHelp(sender);
                    break block90;
                }
                if (!args[0].equalsIgnoreCase("gen-docs")) break block90;
                File templateDir = new File(Skript.getInstance().getDataFolder() + "/doc-templates/");
                if (!templateDir.exists()) {
                    Skript.info(sender, "Documentation templates not found. Cannot generate docs!");
                    return true;
                }
                try {
                    File outputDir = new File(Skript.getInstance().getDataFolder() + "/docs");
                    outputDir.mkdirs();
                    HTMLGenerator generator = new HTMLGenerator(templateDir, outputDir);
                    Skript.info(sender, "Generating docs...");
                    generator.generate();
                    Skript.info(sender, "Documentation generated!");
                }
                catch (Exception e) {
                    Skript.exception((Throwable)e, "Exception occurred in Skript's main command", "Used command: /" + label + " " + StringUtils.join(args, " "));
                }
            }
            finally {
                r.stop();
            }
        }
        return true;
    }

    @Nullable
    private static File getScriptFromArgs(CommandSender sender, String[] args, int start) {
        String script = StringUtils.join(args, " ", start, args.length);
        File f = SkriptCommand.getScriptFromName(script);
        if (f == null) {
            Skript.error(sender, (script.endsWith("/") || script.endsWith("\\") ? m_invalid_folder : m_invalid_script).toString(script));
            return null;
        }
        return f;
    }

    @Nullable
    public static File getScriptFromName(String script) {
        File f;
        boolean isFolder;
        boolean bl = isFolder = script.endsWith("/") || script.endsWith("\\");
        if (isFolder) {
            script = script.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        } else if (!StringUtils.endsWithIgnoreCase(script, ".sk")) {
            script = String.valueOf(script) + ".sk";
        }
        if (script.startsWith("-")) {
            script = script.substring(1);
        }
        if (!(f = new File(Skript.getInstance().getDataFolder(), "scripts" + File.separator + script)).exists() && !(f = new File(f.getParentFile(), "-" + f.getName())).exists()) {
            return null;
        }
        return f;
    }

    private static final Collection<File> toggleScripts(File folder, final boolean enable) throws IOException {
        return FileUtils.renameAll(folder, new Converter<String, String>(){

            @Override
            @Nullable
            public String convert(String name) {
                if (StringUtils.endsWithIgnoreCase(name, ".sk") && name.startsWith("-") == enable) {
                    return enable ? name.substring(1) : "-" + name;
                }
                return null;
            }
        });
    }
}

