/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Vectors - Velocity")
@Description(value={"Gets, sets, adds or removes velocity to/from/of an entity"})
@Examples(value={"set player's velocity to {_v}"})
@Since(value="2.2-dev31")
public class ExprVelocity
extends SimplePropertyExpression<Entity, Vector> {
    static {
        ExprVelocity.register(ExprVelocity.class, Vector.class, "velocity", "entities");
    }

    @Override
    protected String getPropertyName() {
        return "velocity";
    }

    @Override
    public Class<Vector> getReturnType() {
        return Vector.class;
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.DELETE) {
            return new Class[]{Number.class};
        }
        return null;
    }

    @Override
    @Nullable
    public Vector convert(Entity e) {
        return e.getVelocity();
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        Entity[] entityArray = (Entity[])this.getExpr().getArray(e);
        int n = entityArray.length;
        int n2 = 0;
        while (n2 < n) {
            Entity ent = entityArray[n2];
            if (ent == null) {
                return;
            }
            switch (mode) {
                case ADD: {
                    ent.setVelocity(ent.getVelocity().add((Vector)delta[0]));
                    break;
                }
                case REMOVE: {
                    ent.setVelocity(ent.getVelocity().subtract((Vector)delta[0]));
                    break;
                }
                case REMOVE_ALL: {
                    break;
                }
                case DELETE: 
                case RESET: {
                    ent.setVelocity(new Vector());
                    break;
                }
                case SET: {
                    ent.setVelocity((Vector)delta[0]);
                }
            }
            ++n2;
        }
    }
}

