/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Is on Ground")
@Description(value={"Checks if entities are on ground or not."})
@Examples(value={"player is not on ground"})
@Since(value="2.2-dev26")
public class CondIsOnGround
extends Condition {
    private Expression<Entity> entities;

    static {
        Skript.registerCondition(CondIsOnGround.class, "%entities% (is|are) on ground");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entities = exprs[0];
        return true;
    }

    @Override
    public boolean check(Event e) {
        return this.entities.check(e, en -> en.isOnGround());
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "is " + (e != null ? this.entities.getAll(e) : "") + " on ground";
    }
}

