/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang.function;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.skript.log.RetainingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.util.Utils;
import org.eclipse.jdt.annotation.Nullable;

public final class Parameter<T> {
    final String name;
    final ClassInfo<T> type;
    @Nullable
    final Expression<? extends T> def;
    final boolean single;

    public Parameter(String name, ClassInfo<T> type, boolean single, @Nullable Expression<? extends T> def) {
        this.name = name != null ? name.toLowerCase() : null;
        this.type = type;
        this.def = def;
        this.single = single;
    }

    public ClassInfo<T> getType() {
        return this.type;
    }

    @Nullable
    public static <T> Parameter<T> newInstance(String name, ClassInfo<T> type, boolean single, @Nullable String def) {
        if (!Variable.isValidVariableName(name, false, false)) {
            Skript.error("An argument's name must be a valid variable name, and cannot be a list variable.");
            return null;
        }
        Expression<String> d = null;
        if (def != null) {
            RetainingLogHandler log = SkriptLogger.startRetainingLog();
            try {
                if (type.getC() == String.class) {
                    if (def.startsWith("\"") && def.endsWith("\"")) {
                        d = VariableString.newInstance(def.substring(1, def.length() - 1));
                    } else {
                        if (def.contains(" ")) {
                            Skript.warning("'" + def + "' contains spaces and is unquoted, which is discouraged");
                        }
                        d = new SimpleLiteral<String>(def, false);
                    }
                } else {
                    d = new SkriptParser(def, 2, ParseContext.DEFAULT).parseExpression(type.getC());
                }
                if (d == null) {
                    log.printErrors("'" + def + "' is not " + type.getName().withIndefiniteArticle());
                    return null;
                }
                log.printLog();
            }
            finally {
                log.stop();
            }
        }
        return new Parameter<T>(name, type, single, d);
    }

    public String toString() {
        return String.valueOf(this.name) + ": " + Utils.toEnglishPlural(this.type.getCodeName(), !this.single) + (this.def != null ? " = " + this.def.toString(null, true) : "");
    }
}

