/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Open Inventory")
@Description(value={"Return the open inventory of a player.", "If no inventory is open, it returns the own player's crafting inventory."})
@Examples(value={"set slot 1 of open inventory of player to diamond sword"})
@Since(value="2.2-dev24")
public class ExprOpenInventory
extends SimplePropertyExpression<Player, Inventory> {
    static {
        ExprOpenInventory.register(ExprOpenInventory.class, Inventory.class, "(current|open|top) inventory", "player");
    }

    @Override
    public Class<? extends Inventory> getReturnType() {
        return Inventory.class;
    }

    @Override
    protected String getPropertyName() {
        return "open inventory";
    }

    @Override
    @Nullable
    public Inventory convert(Player p) {
        return p.getOpenInventory() != null ? p.getOpenInventory().getTopInventory() : null;
    }
}

