/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.doc;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Documentation;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.NoDoc;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.ExpressionInfo;
import ch.njol.skript.lang.SkriptEventInfo;
import ch.njol.skript.lang.SyntaxElementInfo;
import ch.njol.skript.lang.function.Functions;
import ch.njol.skript.lang.function.JavaFunction;
import ch.njol.skript.lang.function.Parameter;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Utils;
import ch.njol.util.Callback;
import ch.njol.util.NonNullPair;
import ch.njol.util.StringUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;

public class HTMLGenerator {
    private File template;
    private File output;
    private String skeleton;

    public HTMLGenerator(File templateDir, File outputDir) {
        this.template = templateDir;
        this.output = outputDir;
        this.skeleton = this.readFile(new File(this.template + "/template.html"));
    }

    public void generate() {
        File[] fileArray = this.template.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.getName().equals("css")) {
                File cssTo = new File(this.output + "/css");
                cssTo.mkdirs();
                File[] fileArray2 = new File(this.template + "/css").listFiles();
                int n3 = fileArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    File css = fileArray2[n4];
                    this.writeFile(new File(cssTo + "/" + css.getName()), this.readFile(css));
                    ++n4;
                }
            } else if (!(f.isDirectory() || f.getName().endsWith("template.html") || f.getName().endsWith(".md"))) {
                Skript.info("Creating documentation for " + f.getName());
                String content = this.readFile(f);
                String page = f.getName().endsWith(".html") ? this.skeleton.replace("${content}", content) : content;
                page = page.replace("${skript.version}", Skript.getVersion().toString());
                page = page.replace("${pagename}", f.getName().replace(".html", ""));
                ArrayList replace = Lists.newArrayList();
                int include = page.indexOf("${include");
                while (include != -1) {
                    int endIncl = page.indexOf("}", include);
                    String name = page.substring(include + 10, endIncl);
                    replace.add(name);
                    include = page.indexOf("${include", endIncl);
                }
                for (String name : replace) {
                    String temp = this.readFile(new File(this.template + "/templates/" + name));
                    page = page.replace("${include " + name + "}", temp);
                }
                int generate = page.indexOf("${generate");
                while (generate != -1) {
                    int nextBracket = page.indexOf("}", generate);
                    String[] genParams = page.substring(generate + 11, nextBracket).split(" ");
                    String generated = "";
                    String descTemp = this.readFile(new File(this.template + "/templates/" + genParams[1]));
                    String genType = genParams[0];
                    if (genType.equals("expressions")) {
                        Iterator<ExpressionInfo<?, ?>> iterator = Skript.getExpressions();
                        while (iterator.hasNext()) {
                            ExpressionInfo<?, ?> expressionInfo = iterator.next();
                            assert (expressionInfo != null);
                            if (expressionInfo.c.getAnnotation(NoDoc.class) != null) continue;
                            String desc = this.generateAnnotated(descTemp, expressionInfo);
                            generated = String.valueOf(generated) + desc;
                        }
                    } else if (genType.equals("effects")) {
                        for (SyntaxElementInfo<? extends Effect> syntaxElementInfo : Skript.getEffects()) {
                            assert (syntaxElementInfo != null);
                            if (syntaxElementInfo.c.getAnnotation(NoDoc.class) != null) continue;
                            generated = String.valueOf(generated) + this.generateAnnotated(descTemp, syntaxElementInfo);
                        }
                    } else if (genType.equals("conditions")) {
                        for (SyntaxElementInfo<? extends Condition> syntaxElementInfo : Skript.getConditions()) {
                            assert (syntaxElementInfo != null);
                            if (syntaxElementInfo.c.getAnnotation(NoDoc.class) != null) continue;
                            generated = String.valueOf(generated) + this.generateAnnotated(descTemp, syntaxElementInfo);
                        }
                    } else if (genType.equals("events")) {
                        for (SkriptEventInfo<?> skriptEventInfo : Skript.getEvents()) {
                            assert (skriptEventInfo != null);
                            if (skriptEventInfo.c.getAnnotation(NoDoc.class) != null) continue;
                            generated = String.valueOf(generated) + this.generateEvent(descTemp, skriptEventInfo);
                        }
                    } else if (genType.equals("classes")) {
                        for (ClassInfo<?> classInfo : Classes.getClassInfos()) {
                            if (ClassInfo.NO_DOC.equals(classInfo.getDocName())) continue;
                            assert (classInfo != null);
                            generated = String.valueOf(generated) + this.generateClass(descTemp, classInfo);
                        }
                    } else if (genType.equals("functions")) {
                        Iterable<JavaFunction<?>> iterable = Functions.getJavaFunctions();
                        for (JavaFunction<?> javaFunction : iterable) {
                            assert (javaFunction != null);
                            generated = String.valueOf(generated) + this.generateFunction(descTemp, javaFunction);
                        }
                    }
                    page = page.replace(page.substring(generate, nextBracket + 1), generated);
                    generate = page.indexOf("${generate", nextBracket);
                }
                this.writeFile(new File(this.output + "/" + f.getName()), page);
            }
            ++n2;
        }
    }

    String generateAnnotated(String descTemp, SyntaxElementInfo<?> info) {
        Class c = info.c;
        String desc = "";
        Name name = c.getAnnotation(Name.class);
        desc = descTemp.replace("${element.name}", name == null ? "Unknown Name" : name.value());
        Since since = c.getAnnotation(Since.class);
        desc = desc.replace("${element.since}", since == null ? "unknown" : since.value());
        Description description = c.getAnnotation(Description.class);
        desc = desc.replace("${element.desc}", Joiner.on((String)"\n").join((Object[])(description == null ? new String[]{} : description.value())));
        desc = desc.replace("${element.desc-safe}", Joiner.on((String)"\\n").join((Object[])(description == null ? new String[]{} : description.value())).replace("\\", "\\\\").replace("\"", "\\\"").replace("\t", "    "));
        Examples examples = c.getAnnotation(Examples.class);
        desc = desc.replace("${element.examples}", Joiner.on((String)"\n<br>").join((Object[])(examples == null ? new String[]{} : examples.value())));
        desc = desc.replace("${element.examples-safe}", Joiner.on((String)"\\n").join((Object[])(examples == null ? new String[]{} : examples.value())).replace("\\", "\\\\").replace("\"", "\\\"").replace("\t", "    "));
        desc = desc.replace("${element.id}", info.c.getSimpleName());
        ArrayList toGen = Lists.newArrayList();
        int generate = desc.indexOf("${generate");
        while (generate != -1) {
            int nextBracket = desc.indexOf("}", generate);
            String data = desc.substring(generate + 11, nextBracket);
            toGen.add(data);
            generate = desc.indexOf("${generate", nextBracket);
        }
        for (String data : toGen) {
            String[] split = data.split(" ");
            String pattern = this.readFile(new File(this.template + "/templates/" + split[1]));
            String patterns = "";
            String[] stringArray = info.patterns;
            int n = info.patterns.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                assert (line != null);
                line = HTMLGenerator.cleanPatterns(line);
                String parsed = pattern.replace("${element.pattern}", line);
                patterns = String.valueOf(patterns) + parsed;
                ++n2;
            }
            String toReplace = "${generate element.patterns " + split[1] + "}";
            desc = desc.replace(toReplace, patterns);
            desc = desc.replace("${generate element.patterns-safe " + split[1] + "}", patterns.replace("\\", "\\\\"));
        }
        assert (desc != null);
        return desc;
    }

    String generateEvent(String descTemp, SkriptEventInfo<?> info) {
        String desc = "";
        String docName = info.getName();
        desc = descTemp.replace("${element.name}", docName);
        String since = info.getSince();
        desc = desc.replace("${element.since}", since == null ? "unknown" : since);
        Object[] description = info.getDescription();
        desc = desc.replace("${element.desc}", Joiner.on((String)"\n").join(description == null ? new String[]{} : description));
        desc = desc.replace("${element.desc-safe}", Joiner.on((String)"\\n").join(description == null ? new String[]{} : description).replace("\\", "\\\\").replace("\"", "\\\"").replace("\t", "    "));
        Object[] examples = info.getExamples();
        desc = desc.replace("${element.examples}", Joiner.on((String)"\n<br>").join(examples == null ? new String[]{} : examples));
        desc = desc.replace("${element.examples-safe}", Joiner.on((String)"\\n").join(examples == null ? new String[]{} : examples).replace("\\", "\\\\").replace("\"", "\\\"").replace("\t", "    "));
        desc = desc.replace("${element.id}", info.getId());
        ArrayList toGen = Lists.newArrayList();
        int generate = desc.indexOf("${generate");
        while (generate != -1) {
            int nextBracket = desc.indexOf("}", generate);
            String data = desc.substring(generate + 11, nextBracket);
            toGen.add(data);
            generate = desc.indexOf("${generate", nextBracket);
        }
        for (String data : toGen) {
            String[] split = data.split(" ");
            String pattern = this.readFile(new File(this.template + "/templates/" + split[1]));
            String patterns = "";
            String[] stringArray = info.patterns;
            int n = info.patterns.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                assert (line != null);
                line = HTMLGenerator.cleanPatterns(line);
                String parsed = pattern.replace("${element.pattern}", line);
                patterns = String.valueOf(patterns) + parsed;
                ++n2;
            }
            desc = desc.replace("${generate element.patterns " + split[1] + "}", patterns);
            desc = desc.replace("${generate element.patterns-safe " + split[1] + "}", patterns.replace("\\", "\\\\"));
        }
        assert (desc != null);
        return desc;
    }

    String generateClass(String descTemp, ClassInfo<?> info) {
        String desc = "";
        String docName = info.getDocName();
        desc = descTemp.replace("${element.name}", docName == null ? "Unknown Name" : docName);
        String since = info.getSince();
        desc = desc.replace("${element.since}", since == null ? "unknown" : since);
        Object[] description = info.getDescription();
        desc = desc.replace("${element.desc}", Joiner.on((String)"\n").join(description == null ? new String[]{} : description));
        desc = desc.replace("${element.desc-safe}", Joiner.on((String)"\\n").join(description == null ? new String[]{} : description).replace("\\", "\\\\").replace("\"", "\\\"").replace("\t", "    "));
        Object[] examples = info.getExamples();
        desc = desc.replace("${element.examples}", Joiner.on((String)"\n<br>").join(examples == null ? new String[]{} : examples));
        desc = desc.replace("${element.examples-safe}", Joiner.on((String)"\\n").join(examples == null ? new String[]{} : examples).replace("\\", "\\\\").replace("\"", "\\\"").replace("\t", "    "));
        desc = desc.replace("${element.id}", info.getCodeName());
        ArrayList toGen = Lists.newArrayList();
        int generate = desc.indexOf("${generate");
        while (generate != -1) {
            int nextBracket = desc.indexOf("}", generate);
            String data = desc.substring(generate + 11, nextBracket);
            toGen.add(data);
            generate = desc.indexOf("${generate", nextBracket);
        }
        for (String data : toGen) {
            String[] split = data.split(" ");
            String pattern = this.readFile(new File(this.template + "/templates/" + split[1]));
            String patterns = "";
            String[] lines = info.getUsage();
            if (lines == null) continue;
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                assert (line != null);
                line = HTMLGenerator.cleanPatterns(line);
                String parsed = pattern.replace("${element.pattern}", line);
                patterns = String.valueOf(patterns) + parsed;
                ++n2;
            }
            desc = desc.replace("${generate element.patterns " + split[1] + "}", patterns);
            desc = desc.replace("${generate element.patterns-safe " + split[1] + "}", patterns.replace("\\", "\\\\"));
        }
        assert (desc != null);
        return desc;
    }

    String generateFunction(String descTemp, JavaFunction<?> info) {
        String desc = "";
        String docName = info.getName();
        desc = descTemp.replace("${element.name}", docName);
        String since = info.getSince();
        desc = desc.replace("${element.since}", since == null ? "unknown" : since);
        Object[] description = info.getDescription();
        desc = desc.replace("${element.desc}", Joiner.on((String)"\n").join(description == null ? new String[]{} : description));
        desc = desc.replace("${element.desc-safe}", Joiner.on((String)"\\n").join(description == null ? new String[]{} : description).replace("\\", "\\\\").replace("\"", "\\\"").replace("\t", "    "));
        Object[] examples = info.getExamples();
        desc = desc.replace("${element.examples}", Joiner.on((String)"\n<br>").join(examples == null ? new String[]{} : examples));
        desc = desc.replace("${element.examples-safe}", Joiner.on((String)"\\n").join(examples == null ? new String[]{} : examples).replace("\\", "\\\\").replace("\"", "\\\"").replace("\t", "    "));
        desc = desc.replace("${element.id}", info.getName());
        ArrayList toGen = Lists.newArrayList();
        int generate = desc.indexOf("${generate");
        while (generate != -1) {
            int nextBracket = desc.indexOf("}", generate);
            String data = desc.substring(generate + 11, nextBracket);
            toGen.add(data);
            generate = desc.indexOf("${generate", nextBracket);
        }
        for (String data : toGen) {
            String[] split = data.split(" ");
            String pattern = this.readFile(new File(this.template + "/templates/" + split[1]));
            String patterns = "";
            Parameter<?>[] params = info.getParameters();
            Object[] types = new String[params.length];
            int i = 0;
            while (i < types.length) {
                types[i] = params[i].getType().getDocName();
                ++i;
            }
            String line = String.valueOf(docName) + "(" + Joiner.on((String)", ").join(types) + ")";
            patterns = String.valueOf(patterns) + pattern.replace("${element.pattern}", line);
            desc = desc.replace("${generate element.patterns " + split[1] + "}", patterns);
            desc = desc.replace("${generate element.patterns-safe " + split[1] + "}", patterns.replace("\\", "\\\\"));
        }
        assert (desc != null);
        return desc;
    }

    String readFile(File f) {
        try {
            return Files.toString((File)f, (Charset)Charset.forName("UTF-8"));
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    void writeFile(File f, String data) {
        try {
            Files.write((CharSequence)data, (File)f, (Charset)Charset.forName("UTF-8"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static final String cleanPatterns(String patterns) {
        String s = StringUtils.replaceAll((CharSequence)Documentation.escapeHTML(patterns).replaceAll("(?<=[\\(\\|])[-0-9]+?\u00a6", "").replace("()", "").replaceAll("\\(([^|]+?)\\|\\)", "[$1]").replaceAll("\\(\\|([^|]+?)\\)", "[$1]").replaceAll("\\((.+?)\\|\\)", "[($1)]").replaceAll("\\(\\|(.+?)\\)", "[($1)]"), "(?<!\\\\)%(.+?)(?<!\\\\)%", new Callback<String, Matcher>(){

            @Override
            public String run(Matcher m) {
                int a;
                String s = m.group(1);
                if (s.startsWith("-")) {
                    s = s.substring(1);
                }
                String flag = "";
                if (s.startsWith("*") || s.startsWith("~")) {
                    flag = s.substring(0, 1);
                    s = s.substring(1);
                }
                if ((a = s.indexOf("@")) != -1) {
                    s = s.substring(0, a);
                }
                StringBuilder b = new StringBuilder("%");
                b.append(flag);
                boolean first = true;
                String[] stringArray = s.split("/");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String c = stringArray[n2];
                    if (!$assertionsDisabled && c == null) {
                        throw new AssertionError();
                    }
                    if (!first) {
                        b.append("/");
                    }
                    first = false;
                    NonNullPair<String, Boolean> p = Utils.getEnglishPlural(c);
                    ClassInfo<?> ci = Classes.getClassInfoNoError(p.getFirst());
                    if (ci != null && ci.getDocName() != null && ci.getDocName() != ClassInfo.NO_DOC) {
                        b.append("<a href='classes.html#").append(p.getFirst()).append("'>").append(ci.getName().toString(p.getSecond())).append("</a>");
                    } else {
                        b.append(c);
                        if (ci != null && ci.getDocName() != ClassInfo.NO_DOC) {
                            Skript.warning("Used class " + p.getFirst() + " has no docName/name defined");
                        }
                    }
                    ++n2;
                }
                return b.append("%").toString();
            }
        });
        assert (s != null) : patterns;
        return s;
    }
}

