/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.hooks.regions.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.hooks.regions.classes.Region;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Is Member/Owner of Region")
@Description(value={"Checks whether a player is a member or owner of a particular region.", "This condition requires a supported regions plugin to be installed."})
@Examples(value={"on region enter:", "\tplayer is the owner of the region", "\tmessage \"Welcome back to %region%!\"", "\tsend \"%player% just entered %region%!\" to all members of the region"})
@Since(value="2.1")
public class CondIsMember
extends Condition {
    private Expression<OfflinePlayer> players;
    Expression<Region> regions;
    boolean owner;

    static {
        Skript.registerCondition(CondIsMember.class, "%offlineplayers% (is|are) (0\u00a6[a] member|1\u00a6[(the|an)] owner) of [[the] region] %regions%", "%offlineplayers% (is|are)(n't| not) (0\u00a6[a] member|1\u00a6[(the|an)] owner) of [[the] region] %regions%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.players = exprs[0];
        this.regions = exprs[1];
        this.owner = parseResult.mark == 1;
        this.setNegated(matchedPattern == 1);
        return true;
    }

    @Override
    public boolean check(final Event e) {
        return this.players.check(e, new Checker<OfflinePlayer>(){

            @Override
            public boolean check(final OfflinePlayer p) {
                return CondIsMember.this.regions.check(e, new Checker<Region>(){

                    @Override
                    public boolean check(Region r) {
                        return (this).CondIsMember.this.owner ? r.isOwner(p) : r.isMember(p);
                    }
                }, CondIsMember.this.isNegated());
            }
        });
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return String.valueOf(this.players.toString(e, debug)) + " " + (this.players.isSingle() ? "is" : "are") + (this.isNegated() ? " not" : "") + " " + (this.owner ? "owner" : "member") + (this.players.isSingle() ? "" : "s") + " of " + this.regions.toString(e, debug);
    }
}

