/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Vectors - Coordinate")
@Description(value={"Gets or sets the x, y or z coordinate of a vector"})
@Examples(value={"set {_v} to vector 1, 2, 3", "send \"%x of {_v}%, %y of {_v}%, %z of {_v}%\"", "add 1 to x of {_v}", "add 2 to y of {_v}", "add 3 to z of {_v}", "send \"%x of {_v}%, %y of {_v}%, %z of {_v}%\"", "set x of {_v} to 1", "set y of {_v} to 2", "set z of {_v} to 3", "send \"%x of {_v}%, %y of {_v}%, %z of {_v}%\""})
@Since(value="2.2-dev28")
public class ExprVectorXYZ
extends SimplePropertyExpression<Vector, Number> {
    private static final String[] axes;
    private int axis;

    static {
        Skript.registerExpression(ExprVectorXYZ.class, Number.class, ExpressionType.PROPERTY, "(0\u00a6x|1\u00a6y|2\u00a6z) of %vector%");
        axes = new String[]{"xx", "yy", "zz"};
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        super.init(exprs, matchedPattern, isDelayed, parseResult);
        this.axis = parseResult.mark;
        return true;
    }

    @Override
    public Double convert(Vector v) {
        return this.axis == 0 ? v.getX() : (this.axis == 1 ? v.getY() : v.getZ());
    }

    @Override
    protected String getPropertyName() {
        return "the " + axes[this.axis] + "-coordinate";
    }

    @Override
    public Class<Number> getReturnType() {
        return Number.class;
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if ((mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE) && this.getExpr().isSingle() && Changer.ChangerUtils.acceptsChange(this.getExpr(), Changer.ChangeMode.SET, Vector.class)) {
            return new Class[]{Number.class};
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        assert (delta != null);
        Vector v = (Vector)this.getExpr().getSingle(e);
        if (v == null) {
            return;
        }
        double n = ((Number)delta[0]).doubleValue();
        switch (mode) {
            case REMOVE: {
                n = -n;
            }
            case ADD: {
                if (this.axis == 0) {
                    v.setX(v.getX() + n);
                } else if (this.axis == 1) {
                    v.setY(v.getY() + n);
                } else {
                    v.setZ(v.getZ() + n);
                }
                this.getExpr().change(e, new Vector[]{v}, Changer.ChangeMode.SET);
                break;
            }
            case SET: {
                if (this.axis == 0) {
                    v.setX(n);
                } else if (this.axis == 1) {
                    v.setY(n);
                } else {
                    v.setZ(n);
                }
                this.getExpr().change(e, new Vector[]{v}, Changer.ChangeMode.SET);
                break;
            }
            case REMOVE_ALL: 
            case DELETE: 
            case RESET: {
                assert (false);
                break;
            }
        }
    }
}

