/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.VectorMath;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Vectors - Create from pitch and yaw")
@Description(value={"Creates a vector from a yaw and pitch value"})
@Examples(value={"set {_v} to vector from yaw 45 and pitch 45"})
@Since(value="2.2-dev28")
public class ExprVectorFromYawAndPitch
extends SimpleExpression<Vector> {
    private Expression<Number> pitch;
    private Expression<Number> yaw;

    static {
        Skript.registerExpression(ExprVectorFromYawAndPitch.class, Vector.class, ExpressionType.SIMPLE, "[new] vector from yaw %number% and pitch %number%");
    }

    protected Vector[] get(Event event) {
        Number y = this.yaw.getSingle(event);
        Number p = this.pitch.getSingle(event);
        if (y == null || p == null) {
            return null;
        }
        float yaw = VectorMath.fromSkriptYaw(VectorMath.wrapAngleDeg(y.floatValue()));
        float pitch = VectorMath.fromSkriptPitch(VectorMath.wrapAngleDeg(p.floatValue()));
        return new Vector[]{VectorMath.fromYawAndPitch(yaw, pitch)};
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends Vector> getReturnType() {
        return Vector.class;
    }

    @Override
    public String toString(@Nullable Event event, boolean b) {
        return "from yaw " + this.yaw.toString() + " and pitch " + this.pitch.toString();
    }

    @Override
    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.yaw = expressions[0];
        this.pitch = expressions[1];
        return true;
    }
}

