/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.Location;
import org.bukkit.SoundCategory;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Play Sound")
@Description(value={"Plays a sound at given location for everyone or just for given players. Playing sounds from resource packs is supported."})
@Examples(value={""})
@Since(value="2.2-dev28")
public class EffPlaySound
extends Effect {
    private Expression<String> sound;
    @Nullable
    private Expression<Number> volume;
    @Nullable
    private Expression<Number> pitch;
    private Expression<Location> location;
    @Nullable
    private Expression<Player> players;

    static {
        Skript.registerEffect(EffPlaySound.class, "play sound %string% [with volume %number%] [(and|with) pitch %number%] at %location% [for %players%]");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.sound = exprs[0];
        this.volume = exprs[1];
        this.pitch = exprs[2];
        this.location = exprs[3];
        this.players = exprs[4];
        return true;
    }

    @Override
    protected void execute(Event e) {
        float pi;
        Location l = this.location.getSingle(e);
        String s = this.sound.getSingle(e);
        float vol = this.volume != null ? this.volume.getSingle(e).floatValue() : 0.0f;
        float f = pi = this.pitch != null ? this.pitch.getSingle(e).floatValue() : 0.0f;
        if (this.players != null) {
            Player[] playerArray = this.players.getAll(e);
            int n = playerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Player p = playerArray[n2];
                p.playSound(l, s, SoundCategory.MASTER, vol, pi);
                ++n2;
            }
        } else {
            l.getWorld().playSound(l, s, vol, pi);
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        if (e != null) {
            return "play sound " + this.sound.getSingle(e);
        }
        return "play sound";
    }
}

