/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.localization.Adjective;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.LanguageChangeListener;
import ch.njol.yggdrasil.YggdrasilSerializable;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.eclipse.jdt.annotation.Nullable;

public enum Color implements YggdrasilSerializable
{
    BLACK(DyeColor.BLACK, ChatColor.BLACK, org.bukkit.Color.fromRGB((int)0x191919)),
    DARK_GREY(DyeColor.GRAY, ChatColor.DARK_GRAY, org.bukkit.Color.fromRGB((int)0x4C4C4C)),
    LIGHT_GREY(DyeColor.SILVER, ChatColor.GRAY, org.bukkit.Color.fromRGB((int)0x999999)),
    WHITE(DyeColor.WHITE, ChatColor.WHITE, org.bukkit.Color.fromRGB((int)0xFFFFFF)),
    DARK_BLUE(DyeColor.BLUE, ChatColor.DARK_BLUE, org.bukkit.Color.fromRGB((int)3361970)),
    BROWN(DyeColor.BROWN, ChatColor.BLUE, org.bukkit.Color.fromRGB((int)6704179)),
    DARK_CYAN(DyeColor.CYAN, ChatColor.DARK_AQUA, org.bukkit.Color.fromRGB((int)5013401)),
    LIGHT_CYAN(DyeColor.LIGHT_BLUE, ChatColor.AQUA, org.bukkit.Color.fromRGB((int)6724056)),
    DARK_GREEN(DyeColor.GREEN, ChatColor.DARK_GREEN, org.bukkit.Color.fromRGB((int)6717235)),
    LIGHT_GREEN(DyeColor.LIME, ChatColor.GREEN, org.bukkit.Color.fromRGB((int)8375321)),
    YELLOW(DyeColor.YELLOW, ChatColor.YELLOW, org.bukkit.Color.fromRGB((int)0xE5E533)),
    ORANGE(DyeColor.ORANGE, ChatColor.GOLD, org.bukkit.Color.fromRGB((int)14188339)),
    DARK_RED(DyeColor.RED, ChatColor.DARK_RED, org.bukkit.Color.fromRGB((int)0x993333)),
    LIGHT_RED(DyeColor.PINK, ChatColor.RED, org.bukkit.Color.fromRGB((int)15892389)),
    DARK_PURPLE(DyeColor.PURPLE, ChatColor.DARK_PURPLE, org.bukkit.Color.fromRGB((int)8339378)),
    LIGHT_PURPLE(DyeColor.MAGENTA, ChatColor.LIGHT_PURPLE, org.bukkit.Color.fromRGB((int)11685080));

    public static final String LANGUAGE_NODE = "colors";
    private final DyeColor wool;
    private final ChatColor chat;
    private final org.bukkit.Color bukkit;
    @Nullable
    Adjective adjective;
    private static final Color[] byWool;
    static final Map<String, Color> byName;
    static final Map<String, Color> byEnglishName;

    static {
        byWool = new Color[16];
        Color[] colorArray = Color.values();
        int n = colorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Color c;
            Color.byWool[c.wool.getWoolData()] = c = colorArray[n2];
            ++n2;
        }
        byName = new HashMap<String, Color>();
        byEnglishName = new HashMap<String, Color>();
        Language.addListener(new LanguageChangeListener(){

            @Override
            public void onLanguageChange() {
                boolean english = byEnglishName.isEmpty();
                byName.clear();
                Color[] colorArray = Color.values();
                int n = colorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] names;
                    Color c = colorArray[n2];
                    String[] stringArray = names = Language.getList("colors." + c.name() + ".names");
                    int n3 = names.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String name = stringArray[n4];
                        byName.put(name.toLowerCase(), c);
                        if (english) {
                            byEnglishName.put(name.toLowerCase(), c);
                        }
                        ++n4;
                    }
                    c.adjective = new Adjective("colors." + c.name() + ".adjective");
                    ++n2;
                }
            }
        });
    }

    private Color(DyeColor wool, ChatColor chat, org.bukkit.Color bukkit) {
        this.wool = wool;
        this.chat = chat;
        this.bukkit = bukkit;
    }

    public byte getDye() {
        return (byte)(15 - this.wool.getWoolData());
    }

    public DyeColor getWoolColor() {
        return this.wool;
    }

    public byte getWool() {
        return this.wool.getWoolData();
    }

    public String getChat() {
        return this.chat.toString();
    }

    public ChatColor asChatColor() {
        return this.chat;
    }

    public Adjective getAdjective() {
        return this.adjective;
    }

    public String toString() {
        Adjective a = this.adjective;
        return a == null ? this.name() : a.toString(-1, 0);
    }

    @Nullable
    public static final Color byName(String name) {
        return byName.get(name.toLowerCase());
    }

    @Nullable
    public static final Color byEnglishName(String name) {
        return byEnglishName.get(name.toLowerCase());
    }

    @Nullable
    public static final Color byWool(short data) {
        if (data < 0 || data >= 16) {
            return null;
        }
        return byWool[data];
    }

    @Nullable
    public static final Color byDye(short data) {
        if (data < 0 || data >= 16) {
            return null;
        }
        return byWool[15 - data];
    }

    public static final Color byWoolColor(DyeColor color) {
        return Color.byWool(color.getWoolData());
    }

    public final org.bukkit.Color getBukkitColor() {
        return this.bukkit;
    }
}

