/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Unix Timestamp")
@Description(value={"Converts real world date to Unix timestamp (yyyy-MM-dd HH:mm:ss z)."})
@Examples(value={"unix time of now"})
@Since(value="2.2-dev20")
public class ExprUnixTime
extends SimplePropertyExpression<ch.njol.skript.util.Date, String> {
    private final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");

    static {
        ExprUnixTime.register(ExprUnixTime.class, String.class, "[unix] time[stamp]", "dates");
    }

    @Override
    @Nullable
    public String convert(ch.njol.skript.util.Date f) {
        return this.format.format(new Date(f.getTimestamp()));
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    protected String getPropertyName() {
        return "unix timestamp";
    }
}

