/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.bukkitutil.HealthUtils;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Events;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Max Health")
@Description(value={"The maximum health of an entity, e.g. 10 for a player"})
@Examples(value={"on join:", "\tset the maximum health of the player to 100", "spawn a giant", "set the last spawned entity's max health to 1000"})
@Since(value="2.0")
@Events(value={"damage", "death"})
public class ExprMaxHealth
extends SimplePropertyExpression<LivingEntity, Double> {
    static {
        ExprMaxHealth.register(ExprMaxHealth.class, Double.class, "max[imum] health", "livingentities");
    }

    @Override
    public Double convert(LivingEntity e) {
        return HealthUtils.getMaxHealth((Damageable)e);
    }

    @Override
    public Class<? extends Double> getReturnType() {
        return Double.class;
    }

    @Override
    protected String getPropertyName() {
        return "max health";
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (!Skript.isRunningMinecraft(1, 5, 2)) {
            Skript.error("The max health of an entity can only be changed in Minecraft 1.6 and later");
            return null;
        }
        if (mode != Changer.ChangeMode.DELETE && mode != Changer.ChangeMode.REMOVE_ALL) {
            return new Class[]{Number.class};
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        double d = delta == null ? 0.0 : ((Number)delta[0]).doubleValue();
        LivingEntity[] livingEntityArray = (LivingEntity[])this.getExpr().getArray(e);
        int n = livingEntityArray.length;
        int n2 = 0;
        while (n2 < n) {
            LivingEntity en = livingEntityArray[n2];
            assert (en != null) : this.getExpr();
            switch (mode) {
                case SET: {
                    HealthUtils.setMaxHealth((Damageable)en, d);
                    break;
                }
                case REMOVE: {
                    d = -d;
                }
                case ADD: {
                    HealthUtils.setMaxHealth((Damageable)en, HealthUtils.getMaxHealth((Damageable)en) + d);
                    break;
                }
                case RESET: {
                    en.resetMaxHealth();
                    break;
                }
                case REMOVE_ALL: 
                case DELETE: {
                    assert (false);
                    break;
                }
            }
            ++n2;
        }
    }
}

