/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptEventHandler;
import ch.njol.skript.events.bukkit.ScheduledEvent;
import ch.njol.skript.events.bukkit.ScheduledNoWorldEvent;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SelfRegisteringSkriptEvent;
import ch.njol.skript.lang.SkriptEventInfo;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.util.Timespan;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.Nullable;

public class EvtPeriodical
extends SelfRegisteringSkriptEvent {
    private Timespan period;
    @Nullable
    private Trigger t;
    @Nullable
    private int[] taskIDs;
    @Nullable
    private transient World[] worlds;

    static {
        Skript.registerEvent("*Periodical", EvtPeriodical.class, ScheduledNoWorldEvent.class, "every %timespan%").description(SkriptEventInfo.NO_DOC);
        Skript.registerEvent("*Periodical", EvtPeriodical.class, ScheduledEvent.class, "every %timespan% in [world[s]] %worlds%").description("An event that is called periodically. The event is used like 'every &lt;<a href='../classes/#timespan'>timespan</a>&gt;', e.g. 'every second' or 'every 5 minutes'.").examples("every second", "every minecraft hour", "every tick # warning: lag!", "every minecraft day in \"world\"").since("1.0");
    }

    @Override
    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parser) {
        this.period = (Timespan)args[0].getSingle();
        if (args.length > 1 && args[1] != null) {
            this.worlds = (World[])args[1].getArray();
        }
        return true;
    }

    void execute(@Nullable World w) {
        Trigger t = this.t;
        if (t == null) {
            assert (false);
            return;
        }
        ScheduledEvent e = w == null ? new ScheduledNoWorldEvent() : new ScheduledEvent(w);
        SkriptEventHandler.logEventStart(e);
        SkriptEventHandler.logTriggerStart(t);
        t.execute(e);
        SkriptEventHandler.logTriggerEnd(t);
        SkriptEventHandler.logEventEnd();
    }

    @Override
    public void register(Trigger t) {
        int[] taskIDs;
        this.t = t;
        if (this.worlds == null) {
            taskIDs = new int[]{Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)Skript.getInstance(), new Runnable(){

                @Override
                public void run() {
                    EvtPeriodical.this.execute(null);
                }
            }, this.period.getTicks_i(), this.period.getTicks_i())};
        } else {
            taskIDs = new int[this.worlds.length];
            int i = 0;
            while (i < this.worlds.length) {
                final World w = this.worlds[i];
                taskIDs[i] = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)Skript.getInstance(), new Runnable(){

                    @Override
                    public void run() {
                        EvtPeriodical.this.execute(w);
                    }
                }, this.period.getTicks_i() - w.getFullTime() % this.period.getTicks_i(), this.period.getTicks_i());
                assert (this.worlds != null);
                ++i;
            }
        }
        this.taskIDs = taskIDs;
    }

    @Override
    public void unregister(Trigger t) {
        assert (t == this.t);
        this.t = null;
        assert (this.taskIDs != null);
        int[] nArray = this.taskIDs;
        int n = this.taskIDs.length;
        int n2 = 0;
        while (n2 < n) {
            int taskID = nArray[n2];
            Bukkit.getScheduler().cancelTask(taskID);
            ++n2;
        }
    }

    @Override
    public void unregisterAll() {
        this.t = null;
        assert (this.taskIDs != null);
        int[] nArray = this.taskIDs;
        int n = this.taskIDs.length;
        int n2 = 0;
        while (n2 < n) {
            int taskID = nArray[n2];
            Bukkit.getScheduler().cancelTask(taskID);
            ++n2;
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "every " + this.period;
    }
}

