/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.bukkitutil.HealthUtils;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.GameMode;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Kill")
@Description(value={"Kills an entity.", "Note: This effect does not set the entitie's health to 0 (which causes issues), but damages the entity by 100 times its maximum health."})
@Examples(value={"kill the player", "kill all creepers in the player's world", "kill all endermen, witches and bats"})
@Since(value="1.0")
public class EffKill
extends Effect {
    private Expression<Entity> entities;

    static {
        Skript.registerEffect(EffKill.class, "kill %entities%");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.entities = vars[0];
        return true;
    }

    @Override
    protected void execute(Event e) {
        Entity[] entityArray = this.entities.getArray(e);
        int n = entityArray.length;
        int n2 = 0;
        while (n2 < n) {
            Entity entity = entityArray[n2];
            if (entity instanceof ArmorStand || entity instanceof Vehicle) {
                entity.remove();
            } else if (entity instanceof Damageable) {
                boolean creative;
                boolean bl = creative = entity instanceof Player && ((Player)entity).getGameMode() == GameMode.CREATIVE;
                if (creative) {
                    ((Player)entity).setGameMode(GameMode.SURVIVAL);
                }
                HealthUtils.damage((Damageable)entity, HealthUtils.getMaxHealth((Damageable)((LivingEntity)entity)) * 100.0);
                if (creative) {
                    ((Player)entity).setGameMode(GameMode.CREATIVE);
                }
            }
            ++n2;
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "kill " + this.entities.toString(e, debug);
    }
}

