/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.localization.Adjective;
import ch.njol.skript.localization.Noun;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.coll.CollectionUtils;
import java.util.Arrays;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

public class DroppedItemData
extends EntityData<Item> {
    private static final Adjective m_adjective;
    @Nullable
    private ItemType[] types;

    static {
        DroppedItemData.register(DroppedItemData.class, "dropped item", Item.class, "dropped item");
        m_adjective = new Adjective("entities.dropped item.adjective");
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        if (exprs.length > 0 && exprs[0] != null) {
            this.types = (ItemType[])exprs[0].getAll();
        }
        return true;
    }

    @Override
    protected boolean init(@Nullable Class<? extends Item> c, @Nullable Item e) {
        if (e != null) {
            ItemStack i = e.getItemStack();
            if (i == null) {
                return false;
            }
            this.types = new ItemType[]{new ItemType(i)};
        }
        return true;
    }

    @Override
    protected boolean match(Item entity) {
        if (this.types != null) {
            ItemType[] itemTypeArray = this.types;
            int n = this.types.length;
            int n2 = 0;
            while (n2 < n) {
                ItemType t = itemTypeArray[n2];
                if (t.isOfType(entity.getItemStack())) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        return true;
    }

    @Override
    public void set(Item entity) {
        ItemType t = CollectionUtils.getRandom(this.types);
        assert (t != null);
        entity.setItemStack(t.getItem().getRandom());
    }

    @Override
    public boolean isSupertypeOf(EntityData<?> e) {
        if (!(e instanceof DroppedItemData)) {
            return false;
        }
        DroppedItemData d = (DroppedItemData)e;
        if (this.types != null) {
            return d.types != null && ItemType.isSubset(this.types, d.types);
        }
        return true;
    }

    @Override
    public Class<? extends Item> getType() {
        return Item.class;
    }

    @Override
    public EntityData getSuperType() {
        return new DroppedItemData();
    }

    @Override
    public String toString(int flags) {
        Object[] types = this.types;
        if (types == null) {
            return super.toString(flags);
        }
        StringBuilder b = new StringBuilder();
        b.append(Noun.getArticleWithSpace(types[0].getTypes().get(0).getGender(), flags));
        b.append(m_adjective.toString(types[0].getTypes().get(0).getGender(), flags));
        b.append(" ");
        b.append(Classes.toString(types, flags & 0xFFFFFFF9, false));
        return b.toString();
    }

    @Override
    @Deprecated
    protected boolean deserialize(String s) {
        if (s.isEmpty()) {
            return true;
        }
        this.types = ItemType.deserialize(s);
        return this.types != null;
    }

    @Override
    protected boolean equals_i(EntityData<?> obj) {
        if (!(obj instanceof DroppedItemData)) {
            return false;
        }
        return Arrays.equals(this.types, ((DroppedItemData)obj).types);
    }

    @Override
    protected int hashCode_i() {
        return Arrays.hashCode(this.types);
    }
}

