/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import org.bukkit.entity.Creeper;
import org.eclipse.jdt.annotation.Nullable;

public class CreeperData
extends EntityData<Creeper> {
    private int powered = 0;

    static {
        EntityData.register(CreeperData.class, "creeper", Creeper.class, 1, "unpowered creeper", "creeper", "powered creeper");
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.powered = matchedPattern - 1;
        return true;
    }

    @Override
    protected boolean init(@Nullable Class<? extends Creeper> c, @Nullable Creeper e) {
        this.powered = e == null ? 0 : (e.isPowered() ? 1 : -1);
        return true;
    }

    @Override
    public void set(Creeper c) {
        if (this.powered != 0) {
            c.setPowered(this.powered == 1);
        }
    }

    @Override
    public boolean match(Creeper entity) {
        return this.powered == 0 || entity.isPowered() == (this.powered == 1);
    }

    @Override
    public Class<Creeper> getType() {
        return Creeper.class;
    }

    @Override
    protected int hashCode_i() {
        return this.powered;
    }

    @Override
    protected boolean equals_i(EntityData<?> obj) {
        if (!(obj instanceof CreeperData)) {
            return false;
        }
        CreeperData other = (CreeperData)obj;
        return this.powered == other.powered;
    }

    @Override
    protected boolean deserialize(String s) {
        try {
            this.powered = Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public boolean isSupertypeOf(EntityData<?> e) {
        if (e instanceof CreeperData) {
            return this.powered == 0 || ((CreeperData)e).powered == this.powered;
        }
        return false;
    }

    @Override
    public EntityData getSuperType() {
        return new CreeperData();
    }
}

