/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util.chat;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.LanguageChangeListener;
import ch.njol.skript.util.chat.ChatCode;
import ch.njol.skript.util.chat.MessageComponent;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;

public class ChatMessages {
    public static boolean parseLinks = false;
    static final Map<String, ChatCode> codes = new HashMap<String, ChatCode>();
    static final ChatCode[] colorChars = new ChatCode[256];
    static final Gson gson;
    static final int msgCacheSize = 100;
    static final Map<String, String> msgCache;

    static {
        msgCache = new LinkedHashMap<String, String>(){
            private static final long serialVersionUID = 8780868977339889766L;

            @Override
            protected boolean removeEldestEntry(@Nullable Map.Entry<String, String> eldest) {
                return this.size() > 100;
            }
        };
        Gson nullableGson = new GsonBuilder().registerTypeAdapter(Boolean.TYPE, (Object)new MessageComponent.BooleanSerializer()).create();
        assert (nullableGson != null);
        gson = nullableGson;
    }

    public static void registerListeners() {
        Language.addListener(new LanguageChangeListener(){

            @Override
            public void onLanguageChange() {
                codes.clear();
                Skript.debug("Parsing message style lang files");
                ChatCode[] chatCodeArray = ChatCode.values();
                int n = chatCodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String name;
                    int n3;
                    int n4;
                    String[] stringArray;
                    ChatCode code = chatCodeArray[n2];
                    if (code.colorCode != null) {
                        stringArray = Language.getList("colors." + code.langName + ".names");
                        n4 = stringArray.length;
                        n3 = 0;
                        while (n3 < n4) {
                            name = stringArray[n3];
                            codes.put(name, code);
                            ++n3;
                        }
                    } else {
                        stringArray = Language.getList("chat styles." + code.langName);
                        n4 = stringArray.length;
                        n3 = 0;
                        while (n3 < n4) {
                            name = stringArray[n3];
                            codes.put(name, code);
                            ++n3;
                        }
                    }
                    if (code.colorChar != '\u0000') {
                        ChatMessages.colorChars[code.colorChar] = code;
                    }
                    ++n2;
                }
                ChatMessages.colorChars[107] = ChatCode.obfuscated;
                ChatMessages.colorChars[108] = ChatCode.bold;
                ChatMessages.colorChars[109] = ChatCode.strikethrough;
                ChatMessages.colorChars[110] = ChatCode.underlined;
                ChatMessages.colorChars[111] = ChatCode.italic;
                ChatMessages.colorChars[114] = ChatCode.reset;
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    public static List<MessageComponent> parse(String msg) {
        chars = msg.toCharArray();
        components = new ArrayList<MessageComponent>();
        current = new MessageComponent();
        components.add(current);
        curStr = new StringBuilder();
        i = 0;
        while (i < chars.length) {
            block24: {
                block25: {
                    block23: {
                        c = chars[i];
                        code = null;
                        param = "";
                        varParam = null;
                        if (!ChatMessages.parseLinks || c != 'h') break block23;
                        rest = msg.substring(i);
                        link = null;
                        if (rest.startsWith("http://") || rest.startsWith("https://")) {
                            link = rest.split(" ", 2)[0];
                        }
                        if (link == null || link.isEmpty()) break block23;
                        text = curStr.toString();
                        curStr = new StringBuilder();
                        if (!ChatMessages.$assertionsDisabled && text == null) {
                            throw new AssertionError();
                        }
                        current.text = text;
                        old = current;
                        current = new MessageComponent();
                        ChatMessages.copyStyles(old, current);
                        components.add(current);
                        ChatCode.open_url.updateComponent(current, link, null);
                        current.text = link;
                        i += link.length() - 1;
                        current = new MessageComponent();
                        components.add(current);
                        break block24;
                    }
                    if (c != '<') break block25;
                    end = msg.indexOf(62, i);
                    if (end == -1) ** GOTO lbl-1000
                    tag = msg.substring(i + 1, end);
                    if (tag.contains(":")) {
                        split = tag.split(":", 2);
                        name = split[0];
                        param = split[1];
                        if (param.contains("%")) {
                            varParam = VariableString.newInstance(param);
                        }
                    } else {
                        name = tag;
                    }
                    if ((code = ChatMessages.codes.get(name)) == null) ** GOTO lbl-1000
                    if (code.nextComponent()) {
                        text = curStr.toString();
                        curStr = new StringBuilder();
                        if (!ChatMessages.$assertionsDisabled && text == null) {
                            throw new AssertionError();
                        }
                        current.text = text;
                        old = current;
                        current = new MessageComponent();
                        if (code.equals((Object)ChatCode.reset)) {
                            current.reset = true;
                        }
                        ChatMessages.copyStyles(old, current);
                        components.add(current);
                    }
                    if (code.colorCode != null) {
                        current.color = code.colorCode;
                    } else {
                        code.updateComponent(current, param, varParam);
                    }
                    i = end;
                    break block24;
                }
                if (c == '&' || c == '\u00a7') {
                    if (i == chars.length - 1) {
                        curStr.append(c);
                    } else {
                        color = chars[i + 1];
                        code = ChatMessages.colorChars[color];
                        if (code == null) {
                            curStr.append(c).append(color);
                        } else {
                            if (code.nextComponent()) {
                                text = curStr.toString();
                                curStr = new StringBuilder();
                                if (!ChatMessages.$assertionsDisabled && text == null) {
                                    throw new AssertionError();
                                }
                                current.text = text;
                                old = current;
                                current = new MessageComponent();
                                if (code.equals((Object)ChatCode.reset)) {
                                    current.reset = true;
                                }
                                ChatMessages.copyStyles(old, current);
                                components.add(current);
                            }
                            if (code.colorCode != null) {
                                current.color = code.colorCode;
                            } else {
                                code.updateComponent(current, param, varParam);
                            }
                        }
                        ++i;
                    }
                } else lbl-1000:
                // 3 sources

                {
                    curStr.append(c);
                }
            }
            ++i;
        }
        text = curStr.toString();
        if (!ChatMessages.$assertionsDisabled && text == null) {
            throw new AssertionError();
        }
        current.text = text;
        return components;
    }

    public static MessageComponent[] parseToArray(String msg) {
        return ChatMessages.parse(msg).toArray(new MessageComponent[0]);
    }

    public static String toJson(String msg) {
        ComponentList componentList = new ComponentList(ChatMessages.parse(msg));
        String json = gson.toJson((Object)componentList);
        assert (json != null);
        return json;
    }

    public static String toJson(MessageComponent[] components) {
        ComponentList componentList = new ComponentList(components);
        String json = gson.toJson((Object)componentList);
        assert (json != null);
        return json;
    }

    public static void copyStyles(MessageComponent from, MessageComponent to) {
        if (to.reset) {
            return;
        }
        if (!to.bold) {
            to.bold = from.bold;
        }
        if (!to.italic) {
            to.italic = from.italic;
        }
        if (!to.underlined) {
            to.underlined = from.underlined;
        }
        if (!to.strikethrough) {
            to.strikethrough = from.strikethrough;
        }
        if (!to.obfuscated) {
            to.obfuscated = from.obfuscated;
        }
        if (to.color.equals("reset")) {
            to.color = from.color;
        }
        if (to.clickEvent == null) {
            to.clickEvent = from.clickEvent;
        }
        if (to.insertion == null) {
            to.insertion = from.insertion;
        }
        if (to.hoverEvent == null) {
            to.hoverEvent = from.hoverEvent;
        }
    }

    public static void shareStyles(MessageComponent[] components) {
        MessageComponent previous = null;
        MessageComponent[] messageComponentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            MessageComponent c = messageComponentArray[n2];
            if (previous != null) {
                assert (c != null);
                ChatMessages.copyStyles(previous, c);
            }
            previous = c;
            ++n2;
        }
    }

    public static MessageComponent plainText(String str) {
        MessageComponent component = new MessageComponent();
        component.text = str;
        return component;
    }

    private static class ComponentList {
        @Deprecated
        public String text = "";
        @Nullable
        public MessageComponent[] extra;

        public ComponentList(List<MessageComponent> components) {
            this.extra = components.toArray(new MessageComponent[0]);
        }

        public ComponentList(MessageComponent[] components) {
            this.extra = components;
        }
    }
}

