/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.bukkitutil.ProjectileUtils;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Shooter")
@Description(value={"The shooter of a projectile."})
@Examples(value={"shooter is a skeleton"})
@Since(value="1.3.7")
public class ExprShooter
extends PropertyExpression<Projectile, LivingEntity> {
    static {
        Skript.registerExpression(ExprShooter.class, LivingEntity.class, ExpressionType.SIMPLE, "[the] shooter [of %projectile%]");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        return true;
    }

    protected LivingEntity[] get(Event e, Projectile[] source) {
        return this.get(source, new Converter<Projectile, LivingEntity>(){

            @Override
            @Nullable
            public LivingEntity convert(Projectile p) {
                Object o = ProjectileUtils.getShooter(p);
                if (o instanceof LivingEntity) {
                    return (LivingEntity)o;
                }
                return null;
            }
        });
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return new Class[]{LivingEntity.class};
        }
        return super.acceptChange(mode);
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            assert (delta != null);
            Projectile[] projectileArray = (Projectile[])this.getExpr().getArray(e);
            int n = projectileArray.length;
            int n2 = 0;
            while (n2 < n) {
                Projectile p = projectileArray[n2];
                assert (p != null) : this.getExpr();
                ProjectileUtils.setShooter(p, delta[0]);
                ++n2;
            }
        } else {
            super.change(e, delta, mode);
        }
    }

    @Override
    public Class<LivingEntity> getReturnType() {
        return LivingEntity.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "the shooter" + (this.getExpr().isDefault() ? "" : " of " + this.getExpr().toString(e, debug));
    }
}

