/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.bukkitutil.HealthUtils;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Events;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Getter;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Health")
@Description(value={"The health of a creature, e.g. a player, mob, villager, etc. from 0 to the creature's max health, e.g. 10 for players."})
@Examples(value={"message \"You have %health% HP left.\""})
@Since(value="1.0")
@Events(value={"damage"})
public class ExprHealth
extends PropertyExpression<LivingEntity, Double> {
    static {
        ExprHealth.register(ExprHealth.class, Double.class, "health", "livingentities");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.setExpr(vars[0]);
        return true;
    }

    protected Double[] get(Event e, LivingEntity[] source) {
        return this.get(source, new Getter<Double, LivingEntity>(){

            @Override
            public Double get(LivingEntity entity) {
                return HealthUtils.getHealth((Damageable)entity);
            }
        });
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "the health of " + this.getExpr().toString(e, debug);
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.REMOVE_ALL) {
            return null;
        }
        return CollectionUtils.array(Number.class);
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        double d = delta == null ? 0.0 : ((Number)delta[0]).doubleValue();
        switch (mode) {
            case SET: 
            case DELETE: {
                LivingEntity[] livingEntityArray = (LivingEntity[])this.getExpr().getArray(e);
                int n = livingEntityArray.length;
                int n2 = 0;
                while (n2 < n) {
                    LivingEntity entity = livingEntityArray[n2];
                    assert (entity != null) : this.getExpr();
                    HealthUtils.setHealth((Damageable)entity, d);
                    ++n2;
                }
                break;
            }
            case REMOVE: {
                d = -d;
            }
            case ADD: {
                LivingEntity[] livingEntityArray = (LivingEntity[])this.getExpr().getArray(e);
                int n = livingEntityArray.length;
                int n3 = 0;
                while (n3 < n) {
                    LivingEntity entity = livingEntityArray[n3];
                    assert (entity != null) : this.getExpr();
                    HealthUtils.heal((Damageable)entity, d);
                    ++n3;
                }
                break;
            }
            case RESET: {
                LivingEntity[] livingEntityArray = (LivingEntity[])this.getExpr().getArray(e);
                int n = livingEntityArray.length;
                int n4 = 0;
                while (n4 < n) {
                    LivingEntity entity = livingEntityArray[n4];
                    assert (entity != null) : this.getExpr();
                    HealthUtils.setHealth((Damageable)entity, HealthUtils.getMaxHealth((Damageable)entity));
                    ++n4;
                }
                break;
            }
            case REMOVE_ALL: {
                assert (false);
                break;
            }
        }
    }

    @Override
    public Class<Double> getReturnType() {
        return Double.class;
    }
}

