/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Force Respawn")
@Description(value={"Forces player(s) to respawn if they are dead. If this is called without delay from death event, one tick is waited before respawn attempt."})
@Examples(value={"on death of player:", "\tforce event-player to respawn"})
@Since(value="2.2-dev21")
public class EffRespawn
extends Effect {
    private Expression<Player> players;
    private boolean hasDelay;

    static {
        Skript.registerEffect(EffRespawn.class, "force %players% to respawn");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.players = exprs[0];
        if (ScriptLoader.isCurrentEvent(PlayerDeathEvent.class) && ScriptLoader.hasDelayBefore.isTrue()) {
            this.hasDelay = true;
        }
        return true;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "respawn " + this.players.toString(e, debug);
    }

    @Override
    protected void execute(Event e) {
        Player[] playerArray = this.players.getArray(e);
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            final Player p = playerArray[n2];
            if (this.hasDelay) {
                new BukkitRunnable(){

                    public void run() {
                        p.spigot().respawn();
                    }
                }.runTaskLater((Plugin)Skript.getInstance(), 1L);
            } else {
                p.spigot().respawn();
            }
            ++n2;
        }
    }
}

