/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.util.Math2;
import ch.njol.util.NullableChecker;
import ch.njol.util.coll.iterator.StoppableIterator;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;

public class BlockLineIterator
extends StoppableIterator<Block> {
    public BlockLineIterator(final Block start, final Block end) throws IllegalStateException {
        super(new BlockIterator(start.getWorld(), BlockLineIterator.fitInWorld(start.getLocation().add(0.5, 0.5, 0.5), end.getLocation().subtract(start.getLocation()).toVector()), end.equals(start) ? new Vector(1, 0, 0) : end.getLocation().subtract(start.getLocation()).toVector(), 0.0, 0), new NullableChecker<Block>(){
            private final double overshotSq;
            {
                this.overshotSq = Math.pow(block.getLocation().distance(block2.getLocation()) + 2.0, 2.0);
            }

            @Override
            public boolean check(@Nullable Block b) {
                if (!$assertionsDisabled && b == null) {
                    throw new AssertionError();
                }
                if (b.getLocation().distanceSquared(start.getLocation()) > this.overshotSq) {
                    throw new IllegalStateException("BlockLineIterator missed the end block!");
                }
                return b.equals(end);
            }
        }, true);
    }

    public BlockLineIterator(final Location start, Vector dir, double dist) throws IllegalStateException {
        super(new BlockIterator(start.getWorld(), BlockLineIterator.fitInWorld(start, dir), dir, 0.0, 0), new NullableChecker<Block>(dist){
            private final double distSq;
            {
                this.distSq = d * d;
            }

            @Override
            public boolean check(@Nullable Block b) {
                return b != null && b.getLocation().add(0.5, 0.5, 0.5).distanceSquared(start) >= this.distSq;
            }
        }, false);
    }

    public BlockLineIterator(Block start, Vector dir, double dist) throws IllegalStateException {
        this(start.getLocation().add(0.5, 0.5, 0.5), dir, dist);
    }

    private static final Vector fitInWorld(Location l, Vector dir) {
        if (l.getBlockY() >= 0 && l.getBlockY() < l.getWorld().getMaxHeight()) {
            return l.toVector();
        }
        double y = Math2.fit(0.0, l.getY(), (double)l.getWorld().getMaxHeight());
        if (Math.abs(dir.getY()) < 1.0E-10) {
            return new Vector(l.getX(), y, l.getZ());
        }
        double dy = y - l.getY();
        double n = dy / dir.getY();
        return l.toVector().add(dir.clone().multiply(n));
    }
}

