/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.config.Config;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionList;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.localization.Noun;
import ch.njol.skript.log.BlockingLogHandler;
import ch.njol.skript.log.RetainingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.StringMode;
import ch.njol.skript.util.Utils;
import ch.njol.skript.util.chat.ChatMessages;
import ch.njol.skript.util.chat.MessageComponent;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import ch.njol.util.StringUtils;
import ch.njol.util.coll.CollectionUtils;
import ch.njol.util.coll.iterator.SingleItemIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

public class VariableString
implements Expression<String> {
    private final String orig;
    @Nullable
    private final Object[] string;
    private final MessageComponent[][] components;
    private final boolean isSimple;
    @Nullable
    private final String simple;
    private final StringMode mode;
    public static final Map<String, Pattern> variableNames = new HashMap<String, Pattern>();

    private VariableString(String s) {
        this.isSimple = true;
        this.orig = this.simple = Utils.replaceChatStyles(s.replace("\"\"", "\""));
        this.string = null;
        assert (this.simple != null);
        this.components = new MessageComponent[][]{ChatMessages.parseToArray(this.simple)};
        this.mode = StringMode.MESSAGE;
    }

    private VariableString(String orig, Object[] string, StringMode mode) {
        this.orig = orig;
        this.string = new Object[string.length];
        ArrayList<MessageComponent[]> components = new ArrayList<MessageComponent[]>(string.length + 2);
        int i = 0;
        while (i < string.length) {
            Object o = string[i];
            if (o instanceof String) {
                String quotesFixed = ((String)o).replace("\"\"", "\"");
                assert (this.string != null);
                this.string[i] = Utils.replaceChatStyles(quotesFixed);
                components.add(ChatMessages.parseToArray(quotesFixed));
            } else {
                assert (this.string != null);
                this.string[i] = o;
                components.add(null);
            }
            ++i;
        }
        MessageComponent[][] componentArray = (MessageComponent[][])components.toArray((T[])new MessageComponent[0][0]);
        assert (componentArray != null);
        this.components = componentArray;
        this.mode = mode;
        this.isSimple = false;
        this.simple = null;
    }

    @Nullable
    public static VariableString newInstance(String s) {
        return VariableString.newInstance(s, StringMode.MESSAGE);
    }

    public static final boolean isQuotedCorrectly(String s, boolean withQuotes) {
        if (!(!withQuotes || s.startsWith("\"") && s.endsWith("\""))) {
            return false;
        }
        boolean quote = false;
        int i = withQuotes ? 1 : 0;
        while (i < (withQuotes ? s.length() - 1 : s.length())) {
            if (s.charAt(i) != '\"') {
                if (quote) {
                    return false;
                }
            } else {
                quote = !quote;
            }
            ++i;
        }
        return !quote;
    }

    public static final String unquote(String s, boolean surroundingQuotes) {
        assert (VariableString.isQuotedCorrectly(s, surroundingQuotes));
        if (surroundingQuotes) {
            return s.substring(1, s.length() - 1).replace("\"\"", "\"");
        }
        return s.replace("\"\"", "\"");
    }

    @Nullable
    public static VariableString newInstance(String orig, StringMode mode) {
        if (!VariableString.isQuotedCorrectly(orig, false)) {
            return null;
        }
        int n = StringUtils.count(orig, '%');
        if (n % 2 != 0) {
            Skript.error("The percent sign is used for expressions (e.g. %player%). To insert a '%' type it twice: %%.");
            return null;
        }
        String s = orig.replace("\"\"", "\"");
        ArrayList<Object> string = new ArrayList<Object>(n / 2 + 2);
        int c = s.indexOf(37);
        if (c != -1) {
            if (c != 0) {
                string.add(s.substring(0, c));
            }
            while (c != s.length()) {
                String l;
                int b;
                int c2 = s.indexOf(37, c + 1);
                int tagStart = s.indexOf(60, c2);
                int tagEnd = s.indexOf(62, c2);
                if (tagEnd != -1 && (tagStart == -1 || tagStart > tagEnd)) {
                    c = s.indexOf(37, c2 + 1);
                    if (c != -1) continue;
                    c = s.length();
                    continue;
                }
                int a = c;
                while (c2 != -1 && (b = s.indexOf(123, a + 1)) != -1 && b < c2) {
                    a = VariableString.nextVariableBracket(s, b + 1);
                    if (a == -1) {
                        Skript.error("Missing closing bracket '}' to end variable");
                        return null;
                    }
                    c2 = s.indexOf(37, a + 1);
                }
                if (c2 == -1) {
                    assert (false);
                    return null;
                }
                if (c + 1 == c2) {
                    if (string.size() > 0 && string.get(string.size() - 1) instanceof String) {
                        string.set(string.size() - 1, String.valueOf((String)string.get(string.size() - 1)) + "%");
                    } else {
                        string.add("%");
                    }
                } else {
                    RetainingLogHandler log = SkriptLogger.startRetainingLog();
                    try {
                        Expression expr = new SkriptParser(s.substring(c + 1, c2), 1, ParseContext.DEFAULT).parseExpression(Object.class);
                        if (expr == null) {
                            log.printErrors("Can't understand this expression: " + s.substring(c + 1, c2));
                            return null;
                        }
                        if (mode != StringMode.MESSAGE) {
                            string.add(expr);
                        } else {
                            ExpressionInfo i = new ExpressionInfo(expr);
                            if (!(c2 > s.length() - 2 || s.charAt(c2 + 1) != 's' || c2 != s.length() - 2 && Character.isLetter(s.charAt(c2 + 2)))) {
                                i.flags |= 1;
                                ++c2;
                            }
                            if (string.size() > 0 && string.get(string.size() - 1) instanceof String) {
                                String last = (String)string.get(string.size() - 1);
                                if (c2 <= s.length() - 2 && s.charAt(c2 + 1) == '>' && last.endsWith("<")) {
                                    i.toChatStyle = true;
                                    string.set(string.size() - 1, last.substring(0, last.length() - 1));
                                    ++c2;
                                } else {
                                    int l2 = last.lastIndexOf(32, last.endsWith(" ") ? last.length() - 2 : last.length() - 1);
                                    String lastWord = last.substring(l2 + 1).trim();
                                    if (Noun.isLocalIndefiniteArticle(lastWord)) {
                                        i.flags |= 4;
                                    } else if (Noun.isLocalDefiniteArticle(lastWord)) {
                                        i.flags |= 2;
                                    }
                                    if ((i.flags & 6) != 0) {
                                        string.set(string.size() - 1, last.substring(0, l2 + 1));
                                    }
                                }
                            }
                            string.add(i);
                        }
                        log.printLog();
                    }
                    finally {
                        log.stop();
                    }
                }
                c = s.indexOf(37, c2 + 1);
                if (c == -1) {
                    c = s.length();
                }
                if ((l = s.substring(c2 + 1, c)).isEmpty()) continue;
                if (string.size() > 0 && string.get(string.size() - 1) instanceof String) {
                    string.set(string.size() - 1, String.valueOf((String)string.get(string.size() - 1)) + l);
                    continue;
                }
                string.add(l);
            }
        } else {
            string.add(s);
        }
        VariableString.checkVariableConflicts(s, mode, string);
        if (string.size() == 1 && string.get(0) instanceof String) {
            return new VariableString(s);
        }
        Object[] sa = string.toArray();
        assert (sa != null);
        return new VariableString(orig, sa, mode);
    }

    private static void checkVariableConflicts(String name, StringMode mode, @Nullable Iterable<Object> string) {
        Pattern pattern;
        Config script;
        if (mode != StringMode.VARIABLE_NAME || variableNames.containsKey(name)) {
            return;
        }
        if (name.startsWith("%") && (script = ScriptLoader.currentScript) != null) {
            Skript.warning("Starting a variable's name with an expression is discouraged ({" + name + "}). You could prefix it with the script's name: {" + StringUtils.substring(script.getFileName(), 0, -3) + "." + name + "}");
        }
        if (string != null) {
            StringBuilder p = new StringBuilder();
            block0: for (Object o : string) {
                if (o instanceof Expression) {
                    for (ClassInfo<?> ci : Classes.getClassInfos()) {
                        Parser<?> parser = ci.getParser();
                        if (parser == null || !ci.getC().isAssignableFrom(((Expression)o).getReturnType())) continue;
                        p.append("(?!%)" + parser.getVariableNamePattern() + "(?<!%)");
                        continue block0;
                    }
                    p.append("[^%*](.*[^%*])?");
                    continue;
                }
                p.append(Pattern.quote(o.toString()));
            }
            pattern = Pattern.compile(p.toString());
        } else {
            pattern = Pattern.compile(Pattern.quote(name));
        }
        if (!SkriptConfig.disableVariableConflictWarnings.value().booleanValue()) {
            for (Map.Entry<String, Pattern> e : variableNames.entrySet()) {
                if (!e.getValue().matcher(name).matches() && !pattern.matcher(e.getKey()).matches()) continue;
                Skript.warning("Possible name conflict of variables {" + name + "} and {" + e.getKey() + "} (there might be more conflicts).");
                break;
            }
        }
        variableNames.put(name, pattern);
    }

    public static int nextVariableBracket(String s, int start) {
        int n = 0;
        int i = start;
        while (i < s.length()) {
            if (s.charAt(i) == '}') {
                if (n == 0) {
                    return i;
                }
                --n;
            } else if (s.charAt(i) == '{') {
                ++n;
            }
            ++i;
        }
        return -1;
    }

    public static VariableString[] makeStrings(String[] args) {
        VariableString[] strings = new VariableString[args.length];
        int j = 0;
        int i = 0;
        while (i < args.length) {
            VariableString vs = VariableString.newInstance(args[i]);
            if (vs != null) {
                strings[j++] = vs;
            }
            ++i;
        }
        if (j != args.length) {
            strings = Arrays.copyOf(strings, j);
        }
        assert (strings != null);
        return strings;
    }

    @Nullable
    public static VariableString[] makeStringsFromQuoted(List<String> args) {
        VariableString[] strings = new VariableString[args.size()];
        int i = 0;
        while (i < args.size()) {
            assert (args.get(i).startsWith("\"") && args.get(i).endsWith("\""));
            VariableString vs = VariableString.newInstance(args.get(i).substring(1, args.get(i).length() - 1));
            if (vs == null) {
                return null;
            }
            strings[i] = vs;
            ++i;
        }
        return strings;
    }

    public String toString(Event e) {
        if (this.isSimple) {
            assert (this.simple != null);
            return this.simple;
        }
        Object[] string = this.string;
        assert (string != null);
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < string.length) {
            Object o = string[i];
            if (o instanceof Expression) {
                assert (this.mode != StringMode.MESSAGE);
                b.append(Classes.toString((Object[])((Expression)o).getArray(e), true, this.mode));
            } else if (o instanceof ExpressionInfo) {
                assert (this.mode == StringMode.MESSAGE);
                ExpressionInfo info = (ExpressionInfo)o;
                int flags = info.flags;
                if ((flags & 1) == 0 && b.length() > 0 && Math.abs(StringUtils.numberBefore(b, b.length() - 1)) != 1.0) {
                    flags |= 1;
                }
                if (info.toChatStyle) {
                    String s = Classes.toString((Object[])info.expr.getArray(e), flags, VariableString.getLastColor(b));
                    String style = Utils.getChatStyle(s);
                    b.append(style == null ? "<" + s + ">" : style);
                } else {
                    b.append(Classes.toString((Object[])info.expr.getArray(e), flags, VariableString.getLastColor(b)));
                }
            } else {
                b.append(o);
            }
            ++i;
        }
        return b.toString();
    }

    public MessageComponent[] getMessageComponents(Event e) {
        if (this.isSimple) {
            MessageComponent[] c = this.components[0];
            int j = 0;
            while (j < c.length) {
                MessageComponent component = c[j];
                component.variableUpdate(e);
                ++j;
            }
            assert (c != null);
            return c;
        }
        Object[] string = this.string;
        assert (string != null);
        ArrayList<MessageComponent> componentList = new ArrayList<MessageComponent>();
        int i = 0;
        while (i < this.components.length) {
            block23: {
                MessageComponent[] c;
                block21: {
                    Object o;
                    block24: {
                        block22: {
                            c = this.components[i];
                            if (c != null) break block21;
                            o = string[i];
                            if (!(o instanceof VariableString)) break block22;
                            MessageComponent[] c2 = ((VariableString)o).getMessageComponents(e);
                            if (!componentList.isEmpty()) {
                                ChatMessages.copyStyles((MessageComponent)componentList.get(componentList.size() - 1), c2[0]);
                            }
                            componentList.addAll(Arrays.asList(c2));
                            break block23;
                        }
                        if (!(o instanceof ExpressionInfo)) break block24;
                        assert (this.mode == StringMode.MESSAGE);
                        ExpressionInfo info = (ExpressionInfo)o;
                        int flags = info.flags;
                        if (info.expr instanceof VariableString) {
                            MessageComponent[] c2 = ((VariableString)o).getMessageComponents(e);
                            if (!componentList.isEmpty()) {
                                ChatMessages.copyStyles((MessageComponent)componentList.get(componentList.size() - 1), c2[0]);
                            }
                            componentList.addAll(Arrays.asList(c2));
                        } else {
                            String str = Classes.toString((Object[])info.expr.getArray(e), flags, null);
                            if (!componentList.isEmpty()) {
                                MessageComponent last = (MessageComponent)componentList.get(componentList.size() - 1);
                                if (last != null) {
                                    last.text = String.valueOf(last.text) + str;
                                } else {
                                    componentList.add(ChatMessages.plainText(str));
                                }
                            } else {
                                componentList.add(ChatMessages.plainText(str));
                            }
                        }
                        break block23;
                    }
                    if (!(o instanceof Expression)) break block23;
                    assert (this.mode != StringMode.MESSAGE);
                    String str = Classes.toString((Object[])((Expression)o).getArray(e), true, this.mode);
                    if (!componentList.isEmpty()) {
                        MessageComponent last = (MessageComponent)componentList.get(componentList.size() - 1);
                        if (last != null) {
                            last.text = String.valueOf(last.text) + str;
                        } else {
                            componentList.add(ChatMessages.plainText(str));
                        }
                    } else {
                        componentList.add(ChatMessages.plainText(str));
                    }
                    break block23;
                }
                int j = 0;
                while (j < c.length) {
                    MessageComponent component = c[j];
                    component.variableUpdate(e);
                    componentList.add(component);
                    ++j;
                }
            }
            ++i;
        }
        MessageComponent[] componentArray = componentList.toArray(new MessageComponent[0]);
        assert (componentArray != null);
        return componentArray;
    }

    public String toChatString(Event e) {
        return ChatMessages.toJson(this.getMessageComponents(e));
    }

    @Nullable
    private static final ChatColor getLastColor(CharSequence s) {
        int i = s.length() - 2;
        while (i >= 0) {
            ChatColor c;
            if (s.charAt(i) == '\u00a7' && (c = ChatColor.getByChar((char)s.charAt(i + 1))) != null && (c.isColor() || c == ChatColor.RESET)) {
                return c;
            }
            --i;
        }
        return null;
    }

    @Override
    public String toString() {
        return this.toString(null, false);
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        if (this.isSimple) {
            assert (this.simple != null);
            return String.valueOf('\"') + this.simple + '\"';
        }
        Object[] string = this.string;
        assert (string != null);
        StringBuilder b = new StringBuilder("\"");
        Object[] objectArray = string;
        int n = string.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof Expression) {
                b.append("%").append(((Expression)o).toString(e, debug)).append("%");
            } else if (o instanceof ExpressionInfo) {
                b.append("%").append(((ExpressionInfo)o).expr.toString(e, debug)).append("%");
            } else {
                b.append(o);
            }
            ++n2;
        }
        b.append('\"');
        return b.toString();
    }

    public String getDefaultVariableName() {
        if (this.isSimple) {
            assert (this.simple != null);
            return this.simple;
        }
        Object[] string = this.string;
        assert (string != null);
        StringBuilder b = new StringBuilder();
        Object[] objectArray = string;
        int n = string.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof Expression) {
                b.append("<" + Classes.getSuperClassInfo(((Expression)o).getReturnType()).getCodeName() + ">");
            } else {
                b.append(o);
            }
            ++n2;
        }
        return b.toString();
    }

    public boolean isSimple() {
        return this.isSimple;
    }

    public StringMode getMode() {
        return this.mode;
    }

    public VariableString setMode(StringMode mode) {
        if (this.mode == mode || this.isSimple) {
            return this;
        }
        BlockingLogHandler h = SkriptLogger.startLogHandler(new BlockingLogHandler());
        try {
            VariableString vs = VariableString.newInstance(this.orig, mode);
            if (vs == null) {
                assert (false) : this + "; " + (Object)((Object)mode);
                VariableString variableString = this;
                return variableString;
            }
            VariableString variableString = vs;
            return variableString;
        }
        finally {
            h.stop();
        }
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSingle(Event e) {
        return this.toString(e);
    }

    public String[] getArray(Event e) {
        return new String[]{this.toString(e)};
    }

    public String[] getAll(Event e) {
        return new String[]{this.toString(e)};
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public boolean check(Event e, Checker<? super String> c, boolean negated) {
        return SimpleExpression.check(this.getAll(e), c, negated, false);
    }

    @Override
    public boolean check(Event e, Checker<? super String> c) {
        return SimpleExpression.check(this.getAll(e), c, false, false);
    }

    @Override
    @Nullable
    public <R> Expression<? extends R> getConvertedExpression(Class<R> ... to) {
        if (CollectionUtils.containsSuperclass(to, String.class)) {
            return this;
        }
        return null;
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getAnd() {
        return false;
    }

    @Override
    public boolean setTime(int time) {
        return false;
    }

    @Override
    public int getTime() {
        return 0;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    public Iterator<? extends String> iterator(Event e) {
        return new SingleItemIterator<String>(this.toString(e));
    }

    @Override
    public boolean isLoopOf(String s) {
        return false;
    }

    @Override
    public Expression<?> getSource() {
        return this;
    }

    public static final <T> Expression<T> setStringMode(Expression<T> e, StringMode mode) {
        if (e instanceof ExpressionList) {
            Expression<T>[] ls = ((ExpressionList)e).getExpressions();
            int i = 0;
            while (i < ls.length) {
                Expression l = ls[i];
                assert (l != null);
                ls[i] = VariableString.setStringMode(l, mode);
                ++i;
            }
        } else if (e instanceof VariableString) {
            return ((VariableString)e).setMode(mode);
        }
        return e;
    }

    @Override
    public Expression<String> simplify() {
        return this;
    }

    private static final class ExpressionInfo {
        final Expression<?> expr;
        int flags = 0;
        boolean toChatStyle = false;

        ExpressionInfo(Expression<?> expr) {
            this.expr = expr;
        }
    }
}

