/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.CursorSlot;
import ch.njol.skript.util.Slot;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Player;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Cursor Slot")
@Description(value={"The item which player has on their cursor. This slot is always empty if player has no inventories open."})
@Examples(value={"cursor slot of player is dirt", "set cursor slot of player to 64 diamonds"})
@Since(value="2.2-dev17")
public class ExprCursorSlot
extends SimplePropertyExpression<Player, Slot> {
    static {
        ExprCursorSlot.register(ExprCursorSlot.class, Slot.class, "cursor slot", "players");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        super.init(exprs, matchedPattern, isDelayed, parseResult);
        return true;
    }

    @Override
    @Nullable
    public Slot convert(Player p) {
        return new CursorSlot(p);
    }

    @Override
    protected String getPropertyName() {
        return "cursor";
    }

    @Override
    public Class<? extends Slot> getReturnType() {
        return Slot.class;
    }
}

