/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.function.FunctionEvent;
import ch.njol.skript.lang.function.Functions;
import ch.njol.skript.lang.function.ScriptFunction;
import ch.njol.skript.log.RetainingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Return")
@Description(value={"Makes a function return a value"})
@Examples(value={"function double(i: number) :: number:", "\treturn 2 * {_i}"})
@Since(value="2.2")
public class EffReturn
extends Effect {
    private ScriptFunction<?> function;
    private Expression<?> value;

    static {
        Skript.registerEffect(EffReturn.class, "return %objects%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        Expression v;
        ScriptFunction<?> f = Functions.currentFunction;
        if (f == null) {
            Skript.error("The return statement can only be used in a function");
            return false;
        }
        if (!isDelayed.isFalse()) {
            Skript.error("A return statement after a delay is useless, as the calling trigger will resume when the delay starts (and won't get any returned value)");
            return false;
        }
        this.function = f;
        ClassInfo rt = this.function.getReturnType();
        if (rt == null) {
            Skript.error("This function doesn't return any value. Please use 'stop' or 'exit' if you want to stop the function.");
            return false;
        }
        RetainingLogHandler log = SkriptLogger.startRetainingLog();
        try {
            v = exprs[0].getConvertedExpression(rt.getC());
            if (v == null) {
                log.printErrors("This function is declared to return " + rt.getName().withIndefiniteArticle() + ", but " + exprs[0].toString(null, false) + " is not of that type.");
                return false;
            }
            log.printLog();
        }
        finally {
            log.stop();
        }
        if (f.isSingle() && !v.isSingle()) {
            Skript.error("This function is defined to only return a single " + rt.toString() + ", but this return statement can return multiple values.");
            return false;
        }
        this.value = v;
        return true;
    }

    @Override
    @Nullable
    protected TriggerItem walk(Event e) {
        this.debug(e, false);
        if (e instanceof FunctionEvent) {
            this.function.setReturnValue((FunctionEvent)e, this.value.getArray(e));
        } else assert (false) : e;
        return null;
    }

    @Override
    protected void execute(Event e) {
        assert (false);
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "return " + this.value.toString(e, debug);
    }
}

