/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.yggdrasil.xml;

import ch.njol.util.StringUtils;
import ch.njol.yggdrasil.Tag;
import ch.njol.yggdrasil.Yggdrasil;
import ch.njol.yggdrasil.YggdrasilException;
import ch.njol.yggdrasil.YggdrasilOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.OutputStream;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.eclipse.jdt.annotation.Nullable;

@Deprecated
public final class YggXMLOutputStream
extends YggdrasilOutputStream {
    private final OutputStream os;
    private final XMLStreamWriter out;
    private final short version;
    private static final Pattern valid = Pattern.compile("[\\u0009 \\u000A \\u000D \\u0020-\\u007E \\u0085 \\u00A0-\\uD7FF \\uE000-\\uFFFD \\x{10000}\u2013\\x{10FFFF}]*", 4);
    @Nullable
    private String id = null;

    public YggXMLOutputStream(Yggdrasil y, OutputStream out) throws IOException, FactoryConfigurationError {
        super(y);
        this.version = y.version;
        try {
            this.os = out;
            this.out = XMLOutputFactory.newFactory().createXMLStreamWriter(out, "UTF-8");
            this.out.writeStartDocument("utf-8", "1.0");
            this.out.writeStartElement("yggdrasil");
            this.writeAttribute("version", "" + this.version);
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    private String getTypeName(Class<?> c) throws NotSerializableException {
        String s;
        String a = "";
        while (c.isArray()) {
            a = String.valueOf(a) + "[]";
            c = c.getComponentType();
        }
        Tag type = Tag.getType(c);
        switch (type) {
            case T_ENUM: 
            case T_OBJECT: {
                s = this.yggdrasil.getID(c);
                break;
            }
            default: {
                s = type.name;
                break;
            }
            case T_NULL: 
            case T_ARRAY: 
            case T_REFERENCE: {
                throw new YggdrasilException(c.getCanonicalName());
            }
        }
        return String.valueOf(s) + a;
    }

    private static final void validateString(String s) throws IOException {
        if (!valid.matcher(s).matches()) {
            throw new IOException("The string '" + s + "' contains characters illegal in XML 1.0: '" + YggXMLOutputStream.toUnicodeEscapes(valid.matcher(s).replaceAll("")) + "'");
        }
    }

    private static final String toUnicodeEscapes(String s) {
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < s.length()) {
            b.append(String.format("\\u%04x", s.charAt(i)));
            ++i;
        }
        return "" + b;
    }

    private void writeEndElement() throws IOException {
        try {
            this.out.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    private void writeAttribute(String s, String value) throws IOException {
        YggXMLOutputStream.validateString(s);
        YggXMLOutputStream.validateString(value);
        try {
            this.out.writeAttribute(s, value);
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    private void writeCharacters(String s) throws IOException {
        YggXMLOutputStream.validateString(s);
        try {
            this.out.writeCharacters(s);
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected void writeTag(Tag t) throws IOException {
        try {
            if (t == Tag.T_NULL) {
                this.out.writeEmptyElement(t.name);
            } else {
                this.out.writeStartElement(t.name);
            }
            this.writeID();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected void writePrimitiveValue(Object o) throws IOException {
        this.writeCharacters("" + o);
        this.writeEndElement();
    }

    @Override
    protected void writePrimitive_(Object o) throws IOException {
        long value;
        int size;
        Tag type = Tag.getPrimitiveFromWrapper(o.getClass());
        switch (type) {
            case T_BYTE: {
                size = 1;
                value = 0xFFL & (long)((Byte)o).byteValue();
                break;
            }
            case T_SHORT: {
                size = 2;
                value = 0xFFFFL & (long)((Short)o).shortValue();
                break;
            }
            case T_INT: {
                size = 4;
                value = 0xFFFFFFFFL & (long)((Integer)o).intValue();
                break;
            }
            case T_LONG: {
                size = 8;
                value = (Long)o;
                break;
            }
            case T_FLOAT: {
                size = 4;
                value = 0xFFFFFFFFL & (long)Float.floatToIntBits(((Float)o).floatValue());
                break;
            }
            case T_DOUBLE: {
                size = 8;
                value = Double.doubleToLongBits((Double)o);
                break;
            }
            case T_CHAR: {
                size = 2;
                value = 0xFFFFL & (long)((Character)o).charValue();
                break;
            }
            case T_BOOLEAN: {
                size = 0;
                value = (Boolean)o != false ? 1 : 0;
                break;
            }
            default: {
                throw new YggdrasilException("Invalid call to writePrimitive with argument " + o);
            }
        }
        String s = Long.toHexString(value).toUpperCase(Locale.ENGLISH);
        this.writeCharacters(String.valueOf(StringUtils.multiply('0', Math.max(0, 2 * size - s.length()))) + s);
    }

    @Override
    protected void writeStringValue(String s) throws IOException {
        this.writeCharacters(s);
        this.writeEndElement();
    }

    @Override
    protected void writeArrayComponentType(Class<?> contentType) throws IOException {
        this.writeAttribute("componentType", this.getTypeName(contentType));
    }

    @Override
    protected void writeArrayLength(int length) throws IOException {
        this.writeAttribute("length", "" + length);
    }

    @Override
    protected void writeArrayEnd() throws IOException {
        this.writeEndElement();
    }

    @Override
    protected void writeEnumType(String type) throws IOException {
        this.writeAttribute("type", type);
    }

    @Override
    protected void writeEnumID(String id) throws IOException {
        this.writeCharacters(id);
        this.writeEndElement();
    }

    @Override
    protected void writeClassType(Class<?> c) throws IOException {
        this.writeCharacters(this.getTypeName(c));
        this.writeEndElement();
    }

    @Override
    protected void writeReferenceID(int ref) throws IOException {
        this.writeCharacters("" + ref);
        this.writeEndElement();
    }

    @Override
    protected void writeObjectType(String type) throws IOException {
        this.writeAttribute("type", type);
    }

    @Override
    protected void writeNumFields(short numFields) throws IOException {
        this.writeAttribute("numFields", "" + numFields);
    }

    private final void writeID() throws IOException {
        if (this.id != null) {
            this.writeAttribute("id", this.id);
            this.id = null;
        }
    }

    @Override
    protected void writeFieldID(String id) throws IOException {
        this.id = id;
    }

    @Override
    protected void writeObjectEnd() throws IOException {
        this.writeEndElement();
    }

    @Override
    public void flush() throws IOException {
        try {
            this.out.flush();
            this.os.flush();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.out.writeEndElement();
            this.out.writeEndDocument();
            this.out.close();
            this.os.close();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }
}

