/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Item Amount")
@Description(value={"Gets the amount of an <a href='../classes/#itemstack'>item stack</a>."})
@Examples(value={"send \"You have got %item amount of player's tool% %player's tool% in your hand !\" to player"})
@Since(value="2.2-dev24")
public class ExprItemAmount
extends SimpleExpression<Number> {
    private Expression<ItemStack> itemStackExpression;

    static {
        Skript.registerExpression(ExprItemAmount.class, Number.class, ExpressionType.PROPERTY, "item[[ ]stack] (amount|size|number) of %itemstack%");
    }

    @Override
    public boolean init(Expression<?>[] expr, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.itemStackExpression = expr[0];
        return true;
    }

    protected Number[] get(Event e) {
        Number[] numberArray;
        ItemStack stack = this.itemStackExpression.getSingle(e);
        if (stack != null) {
            Number[] numberArray2 = new Number[1];
            numberArray = numberArray2;
            numberArray2[0] = stack.getAmount();
        } else {
            Number[] numberArray3 = new Number[1];
            numberArray = numberArray3;
            numberArray3[0] = 0;
        }
        return numberArray;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        int newAmount;
        ItemStack stack = this.itemStackExpression.getSingle(e);
        int n = newAmount = delta != null ? ((Number)delta[0]).intValue() : 0;
        if (stack != null) {
            switch (mode) {
                case ADD: {
                    stack.setAmount(newAmount + stack.getAmount());
                    break;
                }
                case SET: {
                    stack.setAmount(newAmount);
                    break;
                }
                case REMOVE: {
                    stack.setAmount(stack.getAmount() - newAmount);
                    break;
                }
                case RESET: {
                    stack.setAmount(1);
                    break;
                }
            }
        }
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return mode != Changer.ChangeMode.REMOVE_ALL && mode != Changer.ChangeMode.DELETE ? CollectionUtils.array(Number.class) : null;
    }

    @Override
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public String toString(@Nullable Event event, boolean b) {
        return "item amount";
    }
}

