/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.Skript;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.variables.Variables;
import ch.njol.util.coll.CollectionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Villager;
import org.eclipse.jdt.annotation.Nullable;

public class VillagerData
extends EntityData<Villager> {
    private static List<Villager.Profession> professions;
    private static final boolean hasNitwit;
    @Nullable
    private Villager.Profession profession = null;

    static {
        hasNitwit = Skript.isRunningMinecraft(1, 11);
        Variables.yggdrasil.registerSingleClass(Villager.Profession.class, "Villager.Profession");
        if (Skript.isRunningMinecraft(1, 10)) {
            VillagerData.register(VillagerData.class, "villager", Villager.class, 0, "normal", "villager", "farmer", "librarian", "priest", "blacksmith", "butcher", "nitwit");
            professions = new ArrayList<Villager.Profession>();
            Villager.Profession[] professionArray = Villager.Profession.values();
            int n = professionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Villager.Profession prof = professionArray[n2];
                if (!prof.isZombie()) {
                    professions.add(prof);
                }
                ++n2;
            }
        } else {
            VillagerData.register(VillagerData.class, "villager", Villager.class, 0, "villager", "farmer", "librarian", "priest", "blacksmith", "butcher", "nitwit");
            List<Villager.Profession> prof = Arrays.asList(Villager.Profession.values());
            assert (prof != null);
            professions = prof;
        }
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        if (matchedPattern > 0) {
            this.profession = Villager.Profession.values()[matchedPattern - 1];
        }
        return true;
    }

    @Override
    protected boolean init(@Nullable Class<? extends Villager> c, @Nullable Villager e) {
        this.profession = e == null ? null : e.getProfession();
        return true;
    }

    @Override
    public void set(Villager entity) {
        if (this.profession != null) {
            entity.setProfession(this.profession);
        }
    }

    @Override
    @Nullable
    public Villager spawn(Location loc) {
        Villager v = (Villager)super.spawn(loc);
        if (v == null) {
            return null;
        }
        if (this.profession == null) {
            this.profession = CollectionUtils.getRandom(professions);
            v.setProfession(this.profession);
        }
        if (hasNitwit && this.profession == Villager.Profession.NITWIT) {
            v.setRecipes(Collections.emptyList());
        }
        return v;
    }

    @Override
    protected boolean match(Villager entity) {
        return this.profession == null || entity.getProfession() == this.profession;
    }

    @Override
    public Class<? extends Villager> getType() {
        return Villager.class;
    }

    @Override
    protected int hashCode_i() {
        return this.profession != null ? this.profession.hashCode() : 0;
    }

    @Override
    protected boolean equals_i(EntityData<?> obj) {
        if (!(obj instanceof VillagerData)) {
            return false;
        }
        VillagerData other = (VillagerData)obj;
        return this.profession == other.profession;
    }

    @Override
    protected boolean deserialize(String s) {
        if (s.isEmpty()) {
            return true;
        }
        try {
            this.profession = Villager.Profession.valueOf((String)s);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    public boolean isSupertypeOf(EntityData<?> e) {
        if (e instanceof VillagerData) {
            return this.profession == null || ((VillagerData)e).profession == this.profession;
        }
        return false;
    }

    @Override
    public EntityData getSuperType() {
        return new VillagerData();
    }
}

