/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.Skript;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.variables.Variables;
import org.bukkit.entity.Horse;
import org.eclipse.jdt.annotation.Nullable;

public class HorseData
extends EntityData<Horse> {
    @Nullable
    private Horse.Variant variant;
    @Nullable
    private Horse.Color color;
    @Nullable
    private Horse.Style style;

    static {
        if (Skript.classExists("org.bukkit.entity.Horse")) {
            if (!Skript.isRunningMinecraft(1, 11)) {
                HorseData.register(HorseData.class, "horse", Horse.class, 0, "horse", "donkey", "mule", "undead horse", "skeleton horse");
            }
            Variables.yggdrasil.registerSingleClass(Horse.Variant.class, "Horse.Variant");
            Variables.yggdrasil.registerSingleClass(Horse.Color.class, "Horse.Color");
            Variables.yggdrasil.registerSingleClass(Horse.Style.class, "Horse.Style");
        }
    }

    public HorseData() {
    }

    public HorseData(@Nullable Horse.Variant variant) {
        this.variant = variant;
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        switch (matchedPattern) {
            case 0: {
                this.variant = Horse.Variant.HORSE;
                break;
            }
            case 1: {
                this.variant = Horse.Variant.DONKEY;
                break;
            }
            case 2: {
                this.variant = Horse.Variant.MULE;
                break;
            }
            case 3: {
                this.variant = Horse.Variant.UNDEAD_HORSE;
                break;
            }
            case 4: {
                this.variant = Horse.Variant.SKELETON_HORSE;
            }
        }
        return true;
    }

    @Override
    protected boolean init(@Nullable Class<? extends Horse> c, @Nullable Horse e) {
        if (e != null) {
            this.variant = e.getVariant();
            this.color = e.getColor();
            this.style = e.getStyle();
        }
        return true;
    }

    @Override
    protected boolean match(Horse entity) {
        return !(this.variant != null && this.variant != entity.getVariant() || this.color != null && this.color != entity.getColor() || this.style != null && this.style != entity.getStyle());
    }

    @Override
    public EntityData getSuperType() {
        return new HorseData(this.variant);
    }

    @Override
    public void set(Horse entity) {
        if (this.variant != null) {
            entity.setVariant(this.variant);
        }
        if (this.color != null) {
            entity.setColor(this.color);
        }
        if (this.style != null) {
            entity.setStyle(this.style);
        }
    }

    @Override
    public boolean isSupertypeOf(EntityData<?> e) {
        if (!(e instanceof HorseData)) {
            return false;
        }
        HorseData d = (HorseData)e;
        return !(this.variant != null && this.variant != d.variant || this.color != null && this.color != d.color || this.style != null && this.style != d.style);
    }

    @Override
    public Class<? extends Horse> getType() {
        return Horse.class;
    }

    @Override
    protected boolean deserialize(String s) {
        String[] split = s.split(",");
        if (split.length != 3) {
            return false;
        }
        try {
            this.variant = split[0].isEmpty() ? null : Horse.Variant.valueOf((String)split[0]);
            this.color = split[1].isEmpty() ? null : Horse.Color.valueOf((String)split[1]);
            this.style = split[2].isEmpty() ? null : Horse.Style.valueOf((String)split[2]);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    @Override
    protected int hashCode_i() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.color != null ? this.color.hashCode() : 0);
        result = 31 * result + (this.style != null ? this.style.hashCode() : 0);
        result = 31 * result + (this.variant != null ? this.variant.hashCode() : 0);
        return result;
    }

    @Override
    protected boolean equals_i(EntityData<?> obj) {
        if (!(obj instanceof HorseData)) {
            return false;
        }
        HorseData other = (HorseData)obj;
        if (this.color != other.color) {
            return false;
        }
        if (this.style != other.style) {
            return false;
        }
        return this.variant == other.variant;
    }
}

